/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.postprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.postprocessing.Threshold;

public class ThresholdApplier
extends Operator {
    public ThresholdApplier(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Threshold threshold = this.getInput(Threshold.class);
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        if (predictedLabel == null) {
            throw new UserError(this, 107);
        }
        int zeroIndex = predictedLabel.getMapping().mapString(threshold.getZeroClass());
        int oneIndex = predictedLabel.getMapping().mapString(threshold.getOneClass());
        for (Example example : exampleSet) {
            double oneClassConfidence = example.getConfidence(threshold.getOneClass());
            double crispPrediction = oneClassConfidence > threshold.getThreshold() ? oneIndex : zeroIndex;
            example.setValue(predictedLabel, crispPrediction);
        }
        return new IOObject[]{exampleSet};
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class, Threshold.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

