/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.postprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.operator.postprocessing.PlattParameters;
import edu.udo.cs.yale.operator.postprocessing.PlattScaling;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;

public class PlattScalingModel
extends PredictionModel {
    private PlattParameters parameters;
    private Model model;

    public PlattScalingModel() {
    }

    public PlattScalingModel(Attribute label) {
        super(label);
    }

    public PlattScalingModel(Attribute label, Model model, PlattParameters parameters) {
        super(label);
        this.model = model;
        this.parameters = parameters;
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        Attribute label = this.getLabel();
        int posLabel = label.getMapping().getPositiveIndex();
        int negLabel = label.getMapping().getNegativeIndex();
        String posLabelS = label.getMapping().mapIndex(posLabel);
        String negLabelS = label.getMapping().mapIndex(negLabel);
        this.model.apply(exampleSet);
        Iterator reader = exampleSet.iterator();
        while (reader.hasNext()) {
            double scaledNeg;
            Example example;
            double predicted = PlattScaling.getLogOddsPosConfidence((example = (Example)reader.next()).getConfidence(posLabelS));
            double scaledPos = 1.0 / (1.0 + Math.exp(predicted * this.parameters.getA() + this.parameters.getB()));
            example.setValue(predictedLabel, scaledPos >= (scaledNeg = 1.0 - scaledPos) ? posLabel : negLabel);
            example.setConfidence(posLabelS, scaledPos);
            example.setConfidence(negLabelS, scaledNeg);
        }
    }

    public String toString() {
        String result = String.valueOf(super.toString()) + " (" + this.parameters.toString() + ") " + Tools.getLineSeparator() + "Model: " + this.model.toResultString();
        return result;
    }
}

