/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.postprocessing;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.condition.CombinedInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SpecificInnerOperatorCondition;

public abstract class AbstractSplitChain
extends OperatorChain {
    public AbstractSplitChain(OperatorDescription description) {
        super(description);
    }

    protected abstract SplittedExampleSet createSplittedExampleSet(ExampleSet var1) throws OperatorException;

    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        SplittedExampleSet exampleSet = this.createSplittedExampleSet(inputSet);
        exampleSet.selectSingleSubset(0);
        IOContainer firstInput = new IOContainer(new IOObject[]{exampleSet});
        IOContainer firstResult = this.getOperator(0).apply(firstInput);
        exampleSet.selectSingleSubset(1);
        IOContainer secondInput = firstResult.append(new IOObject[]{exampleSet});
        IOContainer secondResult = this.getOperator(1).apply(secondInput);
        return secondResult.getIOObjects();
    }

    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 0, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 1, new Class[]{ExampleSet.class, Model.class}, new Class[]{Model.class}));
        return condition;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    public int getMinNumberOfInnerOperators() {
        return 2;
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{Model.class};
    }
}

