/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.postprocessing;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.postprocessing.AbstractSplitChain;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteSplitChain
extends AbstractSplitChain {
    private static final String SPLIT_NAME_TRAIN = "number_training_examples";
    private static final String SPLIT_NAME_TEST = "number_test_examples";

    public AbsoluteSplitChain(OperatorDescription description) {
        super(description);
    }

    @Override
    protected SplittedExampleSet createSplittedExampleSet(ExampleSet inputSet) throws OperatorException {
        int size = -1;
        if (this.getParameterAsInt(SPLIT_NAME_TEST) == -1) {
            if (this.getParameterAsInt(SPLIT_NAME_TRAIN) == -1) {
                throw new UserError((Operator)this, 208, SPLIT_NAME_TEST, (Object)SPLIT_NAME_TRAIN);
            }
            size = this.getParameterAsInt(SPLIT_NAME_TRAIN);
        } else {
            if (this.getParameterAsInt(SPLIT_NAME_TRAIN) != -1) {
                throw new UserError((Operator)this, 209, SPLIT_NAME_TEST, (Object)SPLIT_NAME_TRAIN);
            }
            size = inputSet.size() - this.getParameterAsInt(SPLIT_NAME_TEST);
        }
        return new SplittedExampleSet(inputSet, (double)size / (double)inputSet.size(), this.getParameterAsInt("sampling_type"), this.getParameterAsInt("local_random_seed"));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(SPLIT_NAME_TRAIN, "Absolute size of the training set. -1 equal to not defined", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(SPLIT_NAME_TEST, "Absolute size of the test set. -1 equal to not defined", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("sampling_type", "Defines the sampling type of this operator.", SplittedExampleSet.SAMPLING_NAMES, 1));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

