/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance.test;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.test.ExampleTestTools;
import edu.udo.cs.yale.operator.performance.BinaryClassificationPerformance;
import edu.udo.cs.yale.operator.performance.MultiClassificationPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceEvaluator;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.performance.test.CriterionTestCase;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.util.Iterator;
import java.util.LinkedList;

public class ClassificationCriterionTest
extends CriterionTestCase {
    public void testClassificationError() throws Exception {
        Attribute label = ExampleTestTools.attributeYesNo();
        label.setTableIndex(0);
        int no = label.getMapping().mapString("no");
        int yes = label.getMapping().mapString("yes");
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        attributeList.add(label);
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributeList, ExampleTestTools.createDataRowReader(new DataRowFactory(0), new Attribute[]{label}, new String[][]{{"no"}, {"yes"}, {"yes"}, {"no"}, {"yes"}, {"no"}, {"yes"}, {"yes"}, {"yes"}, {"no"}, {"no"}, {"yes"}}));
        AttributeSet attributeSet = new AttributeSet();
        attributeSet.setSpecialAttribute("label", label);
        ExampleSet eSet = exampleTable.createExampleSet(attributeSet);
        Attribute predictedLabel = ExampleTestTools.createPredictedLabel(eSet);
        Iterator r = eSet.iterator();
        Example e = (Example)r.next();
        e.setValue(predictedLabel, no);
        e = (Example)r.next();
        e.setValue(predictedLabel, yes);
        e = (Example)r.next();
        e.setValue(predictedLabel, no);
        e = (Example)r.next();
        e.setValue(predictedLabel, yes);
        e = (Example)r.next();
        e.setValue(predictedLabel, yes);
        e = (Example)r.next();
        e.setValue(predictedLabel, no);
        e = (Example)r.next();
        e.setValue(predictedLabel, yes);
        e = (Example)r.next();
        e.setValue(predictedLabel, no);
        e = (Example)r.next();
        e.setValue(predictedLabel, no);
        e = (Example)r.next();
        e.setValue(predictedLabel, no);
        e = (Example)r.next();
        e.setValue(predictedLabel, yes);
        e = (Example)r.next();
        e.setValue(predictedLabel, yes);
        PerformanceVector pv = new PerformanceVector();
        int i = 0;
        while (i < MultiClassificationPerformance.NAMES.length) {
            pv.addCriterion(new MultiClassificationPerformance(i));
            ++i;
        }
        i = 0;
        while (i < BinaryClassificationPerformance.NAMES.length) {
            pv.addCriterion(new BinaryClassificationPerformance(i));
            ++i;
        }
        PerformanceEvaluator.evaluate(null, eSet, pv, new LinkedList<PerformanceCriterion>(), false);
        ClassificationCriterionTest.assertEquals((String)"accuracy", (double)0.5833333333333334, (double)pv.getCriterion(MultiClassificationPerformance.NAMES[0]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"classification_error", (double)0.4166666666666667, (double)pv.getCriterion(MultiClassificationPerformance.NAMES[1]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"precision", (double)0.6666666666666666, (double)pv.getCriterion(BinaryClassificationPerformance.NAMES[0]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"recall", (double)0.5714285714285714, (double)pv.getCriterion(BinaryClassificationPerformance.NAMES[1]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"fallout", (double)0.4, (double)pv.getCriterion(BinaryClassificationPerformance.NAMES[3]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"true_pos", (double)4.0, (double)pv.getCriterion(BinaryClassificationPerformance.NAMES[7]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"true_neg", (double)3.0, (double)pv.getCriterion(BinaryClassificationPerformance.NAMES[8]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"false_pos", (double)2.0, (double)pv.getCriterion(BinaryClassificationPerformance.NAMES[5]).getAverage(), (double)1.0E-8);
        ClassificationCriterionTest.assertEquals((String)"false_neg", (double)3.0, (double)pv.getCriterion(BinaryClassificationPerformance.NAMES[6]).getAverage(), (double)1.0E-8);
    }

    public void testUCCClone() {
        int[][] counter = new int[][]{{3, 5}, {4, 6}};
        this.cloneTest("", new BinaryClassificationPerformance(7, counter));
        this.cloneTest("", new BinaryClassificationPerformance(8, counter));
        this.cloneTest("", new BinaryClassificationPerformance(5, counter));
        this.cloneTest("", new BinaryClassificationPerformance(6, counter));
    }

    public void testUCCAverage() {
        int[][] counter1 = new int[][]{{3, 5}, {4, 6}};
        int[][] counter2 = new int[][]{{5, 8}, {2, 9}};
        int[][] sum = new int[][]{{8, 13}, {6, 15}};
        BinaryClassificationPerformance[] ucc1 = new BinaryClassificationPerformance[]{new BinaryClassificationPerformance(7, counter1), new BinaryClassificationPerformance(8, counter1), new BinaryClassificationPerformance(5, counter1), new BinaryClassificationPerformance(6, counter1)};
        BinaryClassificationPerformance[] ucc2 = new BinaryClassificationPerformance[]{new BinaryClassificationPerformance(7, counter2), new BinaryClassificationPerformance(8, counter2), new BinaryClassificationPerformance(5, counter2), new BinaryClassificationPerformance(6, counter2)};
        BinaryClassificationPerformance[] avg = new BinaryClassificationPerformance[]{new BinaryClassificationPerformance(7, sum), new BinaryClassificationPerformance(8, sum), new BinaryClassificationPerformance(5, sum), new BinaryClassificationPerformance(6, sum)};
        int i = 0;
        while (i < ucc1.length) {
            ucc1[i].buildAverage(ucc2[i]);
            ClassificationCriterionTest.assertEquals((String)ucc1[i].getName(), (double)avg[i].getMikroAverage(), (double)ucc1[i].getMikroAverage(), (double)1.0E-7);
            ++i;
        }
    }
}

