/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedPerformanceCreator
extends Operator {
    public WeightedPerformanceCreator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        PerformanceVector inputPerformance = this.getInput(PerformanceVector.class);
        HashMap<String, Double> weightMap = new HashMap<String, Double>();
        List weightList = this.getParameterList("criteria_weights");
        for (Object[] entry : weightList) {
            String criterionName = (String)entry[0];
            Double criterionWeight = (Double)entry[1];
            weightMap.put(criterionName, criterionWeight);
        }
        double defaultWeight = this.getParameterAsDouble("default_weight");
        double sum = 0.0;
        double weightSum = 0.0;
        int j = 0;
        while (j < inputPerformance.getSize()) {
            PerformanceCriterion pc = inputPerformance.getCriterion(j);
            Double weightObject = (Double)weightMap.get(pc.getName());
            double weight = weightObject != null ? weightObject : defaultWeight;
            sum += weight * pc.getFitness();
            weightSum += weight;
            ++j;
        }
        PerformanceVector performance = new PerformanceVector();
        performance.addCriterion(new EstimatedPerformance("weighted_performance", sum /= weightSum, 1, false));
        return new IOObject[]{performance};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("default_weight", "The default weight for all criteria not specified in the list 'criteria_weights'.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeList("criteria_weights", "The weights for several performance criteria. Criteria weights not defined in this list are set to 'default_weight'.", new ParameterTypeDouble("criteria_weight", "The weight for the criteria with the given name", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        return types;
    }
}

