/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.viewer.ConfusionMatrixViewer;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.performance.ClassWeightedPerformance;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.Averagable;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class WeightedMultiClassPerformance
extends MeasuredPerformance
implements ClassWeightedPerformance {
    public static final int UNDEFINED = -1;
    public static final int WEIGHTED_RECALL = 0;
    public static final int WEIGHTED_PRECISION = 1;
    public static final String[] NAMES = new String[]{"weighted_mean_recall", "weighted_mean_precision"};
    public static final String[] DESCRIPTIONS = new String[]{"The weighted mean of all per class recall measurements.", "The weighted mean of all per class precision measurements."};
    private int[][] counter;
    private String[] classNames;
    private int type = 0;
    private double[] classWeights;
    private double weightSum;

    public WeightedMultiClassPerformance() {
        this(-1);
    }

    public WeightedMultiClassPerformance(int type) {
        this.type = type;
    }

    public WeightedMultiClassPerformance(WeightedMultiClassPerformance m) {
        super(m);
        this.type = m.type;
        this.classNames = new String[m.classNames.length];
        int i = 0;
        while (i < this.classNames.length) {
            this.classNames[i] = m.classNames[i];
            ++i;
        }
        this.counter = new int[m.counter.length][m.counter.length];
        i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                this.counter[i][j] = m.counter[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static WeightedMultiClassPerformance newInstance(String name) {
        int i = 0;
        while (i < NAMES.length) {
            if (NAMES[i].equals(name)) {
                return new WeightedMultiClassPerformance(i);
            }
            ++i;
        }
        return null;
    }

    public void setWeights(double[] weights) {
        this.weightSum = 0.0;
        double[] dArray = this.classWeights = weights;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            double w = dArray[n];
            this.weightSum += w;
            ++n;
        }
    }

    public void startCounting(ExampleSet eSet) {
        Attribute label = eSet.getAttributes().getLabel();
        List<String> values = label.getMapping().getValues();
        this.counter = new int[values.size()][values.size()];
        this.classNames = new String[values.size()];
        Iterator i = values.iterator();
        int n = 0;
        while (i.hasNext()) {
            this.classNames[n++] = (String)i.next();
        }
    }

    public void countExample(Example example) {
        int label = (int)example.getLabel();
        int plabel = (int)example.getPredictedLabel();
        int[] nArray = this.counter[label];
        int n = plabel;
        nArray[n] = nArray[n] + 1;
    }

    public int getExampleCount() {
        int total = 0;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                total += this.counter[i][j];
                ++j;
            }
            ++i;
        }
        return total;
    }

    public double getMikroAverage() {
        switch (this.type) {
            case 0: {
                int[] columnSums = new int[this.classNames.length];
                int c = 0;
                while (c < columnSums.length) {
                    int r = 0;
                    while (r < this.counter[c].length) {
                        int n = c;
                        columnSums[n] = columnSums[n] + this.counter[c][r];
                        ++r;
                    }
                    ++c;
                }
                double result = 0.0;
                int c2 = 0;
                while (c2 < columnSums.length) {
                    result += this.classWeights[c2] * ((double)this.counter[c2][c2] / (double)columnSums[c2]);
                    ++c2;
                }
                return result /= this.weightSum;
            }
            case 1: {
                int[] rowSums = new int[this.classNames.length];
                int r = 0;
                while (r < this.counter.length) {
                    int c = 0;
                    while (c < this.counter[r].length) {
                        int n = r;
                        rowSums[n] = rowSums[n] + this.counter[c][r];
                        ++c;
                    }
                    ++r;
                }
                double result = 0.0;
                r = 0;
                while (r < rowSums.length) {
                    result += this.classWeights[r] * ((double)this.counter[r][r] / (double)rowSums[r]);
                    ++r;
                }
                return result /= this.weightSum;
            }
        }
        throw new RuntimeException("Unknown type " + this.type + " for weighted multi class performance criterion!");
    }

    public boolean formatPercent() {
        return true;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public double getFitness() {
        return this.getAverage();
    }

    public double getMaxFitness() {
        return 1.0;
    }

    public void buildSingleAverage(Averagable performance) {
        WeightedMultiClassPerformance other = (WeightedMultiClassPerformance)performance;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                int[] nArray = this.counter[i];
                int n = j;
                nArray[n] = nArray[n] + other.counter[i][j];
                ++j;
            }
            ++i;
        }
    }

    private String toWeightString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(", weights: ");
        boolean first = true;
        double[] dArray = this.classWeights;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            double w = dArray[n];
            if (!first) {
                result.append(", ");
            }
            result.append(Tools.formatIntegerIfPossible(w));
            first = false;
            ++n;
        }
        return result.toString();
    }

    public Component getVisualizationComponent(IOContainer ioContainer) {
        return new ConfusionMatrixViewer(this.toWeightString(), this.classNames, this.counter);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(this.toWeightString()));
        result.append(String.valueOf(Tools.getLineSeparator()) + "ConfusionMatrix:" + Tools.getLineSeparator() + "True:");
        int i = 0;
        while (i < this.counter.length) {
            result.append("\t" + this.classNames[i]);
            ++i;
        }
        i = 0;
        while (i < this.counter.length) {
            result.append(String.valueOf(Tools.getLineSeparator()) + this.classNames[i] + ":");
            int j = 0;
            while (j < this.counter[i].length) {
                result.append("\t" + this.counter[j][i]);
                ++j;
            }
            ++i;
        }
        return result.toString();
    }
}

