/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.math.Averagable;

public abstract class SimpleCriterion
extends MeasuredPerformance {
    private double sum = 0.0;
    private double squaresSum = 0.0;
    private int exampleCount = 0;
    private Attribute predictedAttribute;
    private Attribute labelAttribute;

    public SimpleCriterion() {
    }

    public SimpleCriterion(SimpleCriterion sc) {
        super(sc);
        this.sum = sc.sum;
        this.squaresSum = sc.squaresSum;
        this.exampleCount = sc.exampleCount;
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public void countExample(Example example) {
        double plabel;
        double label = example.getValue(this.labelAttribute);
        if (!this.predictedAttribute.isNominal()) {
            plabel = example.getValue(this.predictedAttribute);
        } else {
            String labelS = example.getValueAsString(this.labelAttribute);
            plabel = example.getConfidence(labelS);
            label = 1.0;
        }
        double deviation = this.countExample(label, plabel);
        if (!Double.isNaN(deviation)) {
            this.countExample(deviation);
        } else {
            LogService.logMessage("SimpleCriterion: NaN was generated!", 4);
        }
    }

    protected abstract double countExample(double var1, double var3);

    protected double transform(double value) {
        return value;
    }

    protected void countExample(double deviation) {
        if (!Double.isNaN(deviation)) {
            this.sum += deviation;
            this.squaresSum += deviation * deviation;
            ++this.exampleCount;
        }
    }

    public double getMikroAverage() {
        return this.transform(this.sum / (double)this.exampleCount);
    }

    public double getMikroVariance() {
        double mean = this.getMikroAverage();
        double meanSquares = this.transform(this.squaresSum) / (double)this.exampleCount;
        return meanSquares - mean * mean;
    }

    public void startCounting(ExampleSet eset) throws OperatorException {
        super.startCounting(eset);
        this.exampleCount = 0;
        this.squaresSum = 0.0;
        this.sum = 0.0;
        this.predictedAttribute = eset.getAttributes().getPredictedLabel();
        this.labelAttribute = eset.getAttributes().getLabel();
    }

    public double getFitness() {
        if (this.getAverage() == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 1.0 / this.getAverage();
    }

    public void buildSingleAverage(Averagable performance) {
        SimpleCriterion other = (SimpleCriterion)performance;
        this.sum += other.sum;
        this.squaresSum += other.squaresSum;
        this.exampleCount += other.exampleCount;
    }
}

