/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;

public class RootRelativeSquaredError
extends MeasuredPerformance {
    private Attribute predictedAttribute;
    private Attribute labelAttribute;
    private double deviationSum = 0.0;
    private double relativeSum = 0.0;
    private double trueLabelSum = 0.0;
    private int exampleCounter = 0;

    public RootRelativeSquaredError() {
    }

    public RootRelativeSquaredError(RootRelativeSquaredError rse) {
        super(rse);
        this.deviationSum = rse.deviationSum;
        this.relativeSum = rse.relativeSum;
        this.trueLabelSum = rse.trueLabelSum;
        this.exampleCounter = rse.exampleCounter;
    }

    public String getName() {
        return "root_relative_squared_error";
    }

    public String getDescription() {
        return "Averaged root-relative-squared error";
    }

    public int getExampleCount() {
        return this.exampleCounter;
    }

    public void startCounting(ExampleSet exampleSet) throws OperatorException {
        super.startCounting(exampleSet);
        if (exampleSet.size() <= 1) {
            throw new UserError(null, 919, this.getName(), (Object)"root relative squared error can only be calculated for test sets with more than 2 examples.");
        }
        this.predictedAttribute = exampleSet.getAttributes().getPredictedLabel();
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        this.trueLabelSum = 0.0;
        this.deviationSum = 0.0;
        this.relativeSum = 0.0;
        this.exampleCounter = 0;
        for (Example example : exampleSet) {
            double label = example.getLabel();
            if (Double.isNaN(label)) continue;
            ++this.exampleCounter;
            this.trueLabelSum += label;
        }
    }

    public void countExample(Example example) {
        double plabel;
        double label = example.getValue(this.labelAttribute);
        if (!this.predictedAttribute.isNominal()) {
            plabel = example.getValue(this.predictedAttribute);
        } else {
            String labelS = example.getValueAsString(this.labelAttribute);
            plabel = example.getConfidence(labelS);
            label = 1.0;
        }
        double diff = Math.abs(label - plabel);
        this.deviationSum += diff * diff;
        double relDiff = Math.abs(label - this.trueLabelSum / (double)this.exampleCounter);
        this.relativeSum += relDiff * relDiff;
    }

    public double getMikroAverage() {
        return Math.sqrt(this.deviationSum / this.relativeSum);
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getFitness() {
        return 1.0 / this.getAverage();
    }

    public void buildSingleAverage(Averagable performance) {
        RootRelativeSquaredError other = (RootRelativeSquaredError)performance;
        this.deviationSum += other.deviationSum;
        this.relativeSum += other.relativeSum;
    }
}

