/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ConditionedExampleSet;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NoMissingAttributesCondition;
import edu.udo.cs.yale.operator.OperatorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class RankStatistics {
    public static double rho(ExampleSet eSet, Attribute a, Attribute b, double f) throws OperatorException {
        ExampleSet e = RankStatistics.extract(eSet, a, b);
        double[] ranka = RankStatistics.rank(e, a, f);
        double[] rankb = RankStatistics.rank(e, b, f);
        int nObs = ranka.length;
        double mu2 = (double)(nObs * (nObs + 1) * (nObs + 1)) / 4.0;
        double prod = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        int i = 0;
        while (i < nObs) {
            prod += ranka[i] * rankb[i];
            a2 += ranka[i] * ranka[i];
            b2 += rankb[i] * rankb[i];
            ++i;
        }
        return (prod - mu2) / Math.sqrt((a2 - mu2) * (b2 - mu2));
    }

    public static double rho(ExampleSet eSet, Attribute a, Attribute b) throws OperatorException {
        return RankStatistics.rho(eSet, a, b, 0.0);
    }

    public static double rho(ExampleSet eSet, String a, String b) throws OperatorException {
        return RankStatistics.rho(eSet, eSet.getAttributes().get(a), eSet.getAttributes().get(b));
    }

    public static double rho(ExampleSet eSet, String a, String b, double f) throws OperatorException {
        return RankStatistics.rho(eSet, eSet.getAttributes().get(a), eSet.getAttributes().get(b), f);
    }

    public static double[] rank(ExampleSet eSet, Attribute att, double fuzz) {
        TreeMap map;
        if (fuzz == 0.0) {
            map = new TreeMap();
        } else {
            FuzzyComp fc = new FuzzyComp(fuzz);
            map = new TreeMap(fc);
        }
        double[] rank = new double[eSet.size()];
        Iterator reader = eSet.iterator();
        int i = 0;
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            double x = e.getValue(att);
            if (Double.isNaN(x)) {
                rank[i++] = Double.NaN;
                continue;
            }
            if (!map.containsKey(x)) {
                map.put(x, new ArrayList());
            }
            ((ArrayList)map.get(x)).add(i++);
        }
        double r = 0.0;
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            double x = (Double)iterator.next();
            ArrayList y = (ArrayList)map.get(x);
            double v = r + (1.0 + (double)y.size()) / 2.0;
            Iterator iterator2 = y.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                rank[j] = v;
            }
            r += (double)y.size();
        }
        return rank;
    }

    public static double[] rank(ExampleSet eSet, String att, double fuzz) {
        return RankStatistics.rank(eSet, eSet.getAttributes().get(att), fuzz);
    }

    public static double[] rank(ExampleSet eSet, Attribute att) {
        return RankStatistics.rank(eSet, att, 0.0);
    }

    public static double[] rank(ExampleSet eSet, String att) {
        return RankStatistics.rank(eSet, eSet.getAttributes().get(att));
    }

    private static ExampleSet extract(ExampleSet eSet, Attribute a, Attribute b) {
        ExampleSet e = (ExampleSet)eSet.clone();
        e.getAttributes().clearRegular();
        e.getAttributes().addRegular(a);
        e.getAttributes().addRegular(b);
        return new ConditionedExampleSet(e, new NoMissingAttributesCondition(e, null));
    }

    public static double tau_b(ExampleSet eSet, Attribute a, Attribute b) throws OperatorException {
        ExampleSet e = RankStatistics.extract(eSet, a, b);
        long c = 0L;
        long d = 0L;
        long ta = 0L;
        long tb = 0L;
        long tc = 0L;
        int n = 0;
        for (Example z1 : e) {
            ++n;
            double x = z1.getValue(a);
            double y = z1.getValue(b);
            Iterator j = e.iterator();
            int k = 0;
            while (k < n) {
                j.next();
                ++k;
            }
            while (j.hasNext()) {
                Example z2 = (Example)j.next();
                double xx = z2.getValue(a);
                double yy = z2.getValue(b);
                if (x == xx) {
                    if (y == yy) {
                        ++tc;
                        continue;
                    }
                    ++ta;
                    continue;
                }
                if (y == yy) {
                    ++tb;
                    continue;
                }
                if (x > xx && y > yy || x < xx && y < yy) {
                    ++c;
                    continue;
                }
                ++d;
            }
        }
        double num = c - d;
        double f1 = c + d + ta;
        double f2 = c + d + tb;
        double den = Math.sqrt(f1 * f2);
        return num / den;
    }

    public static double tau_b(ExampleSet eSet, String a, String b) throws OperatorException {
        return RankStatistics.tau_b(eSet, eSet.getAttributes().get(a), eSet.getAttributes().get(b));
    }

    public static double tau_b(ExampleSet eSet, Attribute a, Attribute b, double fuzz) throws OperatorException {
        ExampleSet e = RankStatistics.extract(eSet, a, b);
        FuzzyComp fc = new FuzzyComp(fuzz);
        int c = 0;
        int d = 0;
        int ta = 0;
        int tb = 0;
        int tc = 0;
        int n = 0;
        for (Example z1 : e) {
            ++n;
            double x = z1.getValue(a);
            double y = z1.getValue(b);
            Iterator j = e.iterator();
            int k = 0;
            while (k < n) {
                j.next();
                ++k;
            }
            while (j.hasNext()) {
                Example z2 = (Example)j.next();
                double xx = z2.getValue(a);
                double yy = z2.getValue(b);
                int xc = fc.compare(x, xx);
                int yc = fc.compare(y, yy);
                if (xc == 0) {
                    if (yc == 0) {
                        ++tc;
                        continue;
                    }
                    ++ta;
                    continue;
                }
                if (yc == 0) {
                    ++tb;
                    continue;
                }
                if (xc == yc) {
                    ++c;
                    continue;
                }
                ++d;
            }
        }
        double num = c - d;
        double den = Math.sqrt((c + d + ta) * (c + d + tb));
        return num / den;
    }

    public static double tau_b(ExampleSet eSet, String a, String b, double fuzz) throws OperatorException {
        return RankStatistics.tau_b(eSet, eSet.getAttributes().get(a), eSet.getAttributes().get(b), fuzz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FuzzyComp
    implements Comparator<Double>,
    Serializable {
        private static final long serialVersionUID = -7752907616633799595L;
        private double fuzz;

        FuzzyComp(double f) {
            this.fuzz = Math.abs(f);
        }

        @Override
        public int compare(Double x, Double y) {
            return x > y + this.fuzz ? 1 : (x < y - this.fuzz ? -1 : 0);
        }
    }
}

