/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.operator.performance.RankStatistics;
import edu.udo.cs.yale.tools.math.Averagable;

public class RankCorrelation
extends MeasuredPerformance {
    public static final String[] NAMES = new String[]{"spearman_rho", "kendall_tau"};
    public static final String[] DESCRIPTIONS = new String[]{"The rank correlation between the actual and predicted labels, using Spearman's rho.", "The rank correlation between the actual and predicted labels, using Kendall's tau-b."};
    public static final int RHO = 0;
    public static final int TAU = 1;
    private int counter = 0;
    private double value = Double.NaN;
    private int type = 0;

    public RankCorrelation() {
        this(0);
    }

    public RankCorrelation(int type) {
        this.type = type;
    }

    public RankCorrelation(RankCorrelation rc) {
        super(rc);
        this.type = rc.type;
        this.value = rc.value;
        this.counter = rc.counter;
    }

    public void countExample(Example example) {
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public int getExampleCount() {
        return this.counter;
    }

    public double getFitness() {
        return this.getMikroAverage();
    }

    protected void buildSingleAverage(Averagable averagable) {
        RankCorrelation other = (RankCorrelation)averagable;
        this.counter += other.counter;
        this.value += other.value;
    }

    public double getMikroAverage() {
        return this.value;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public void startCounting(ExampleSet eSet) throws OperatorException {
        this.counter = eSet.size();
        this.value = this.type == 0 ? RankStatistics.rho(eSet, eSet.getAttributes().getLabel(), eSet.getAttributes().getPredictedLabel()) : RankStatistics.tau_b(eSet, eSet.getAttributes().getLabel(), eSet.getAttributes().getPredictedLabel());
    }
}

