/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;
import java.util.Iterator;

public class PredictionTrendAccuracy
extends MeasuredPerformance {
    private int length = 1;
    private int correctCounter = 0;

    public PredictionTrendAccuracy() {
    }

    public PredictionTrendAccuracy(PredictionTrendAccuracy pta) {
        super(pta);
    }

    public String getName() {
        return "prediction_trend_accuracy";
    }

    public String getDescription() {
        return "Measures the average of times a regression prediction was able to correctly predict the trend of the regression.";
    }

    public void startCounting(ExampleSet eSet) throws OperatorException {
        super.startCounting(eSet);
        if (eSet.getAttributes().size() > 0) {
            Attribute attribute = null;
            Iterator<Attribute> iterator = eSet.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute current;
                attribute = current = iterator.next();
            }
            for (Example example : eSet) {
                double predictionTrend;
                double currentLabel = example.getLabel();
                double currentPrediction = example.getPredictedLabel();
                double lastValueBefore = example.getValue(attribute);
                double actualTrend = currentLabel - lastValueBefore;
                if (actualTrend * (predictionTrend = currentPrediction - lastValueBefore) >= 0.0) {
                    ++this.correctCounter;
                }
                ++this.length;
            }
        }
    }

    public int getExampleCount() {
        return 1;
    }

    public void countExample(Example example) {
    }

    public double getFitness() {
        return this.getAverage();
    }

    public double getMikroAverage() {
        return (double)this.correctCounter / (double)this.length;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void buildSingleAverage(Averagable averagable) {
        PredictionTrendAccuracy other = (PredictionTrendAccuracy)averagable;
        this.length += other.length;
        this.correctCounter += other.correctCounter;
    }
}

