/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;

public class PredictionAverage
extends MeasuredPerformance {
    private double sum;
    private double squaredSum;
    private int count;

    public PredictionAverage() {
    }

    public PredictionAverage(PredictionAverage pa) {
        super(pa);
        this.sum = pa.sum;
        this.squaredSum = pa.squaredSum;
        this.count = pa.count;
    }

    public int getExampleCount() {
        return this.count;
    }

    public void countExample(Example example) {
        ++this.count;
        double v = example.getLabel();
        if (!Double.isNaN(v)) {
            this.sum += v;
            this.squaredSum += v * v;
        }
    }

    public double getMikroAverage() {
        return this.sum / (double)this.count;
    }

    public double getMikroVariance() {
        double avg = this.getMikroAverage();
        return this.squaredSum / (double)this.count - avg * avg;
    }

    public void startCounting(ExampleSet set) {
        this.count = 0;
        this.sum = 0.0;
    }

    public String getName() {
        return "prediction_average";
    }

    public double getFitness() {
        return 0.0;
    }

    public void buildSingleAverage(Averagable performance) {
        PredictionAverage other = (PredictionAverage)performance;
        this.sum += other.sum;
        this.squaredSum += other.squaredSum;
        this.count += other.count;
    }

    public String getDescription() {
        return "This is not a real performance measure, but merely the average of the predicted labels.";
    }
}

