/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.operator.performance.PerformanceComparator;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.Averagable;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PerformanceVector
extends AverageVector
implements Saveable {
    private Map<String, Double> currentValues = null;
    private PerformanceComparator comparator = new DefaultComparator();
    private String mainCriterion = null;

    public void setComparator(PerformanceComparator comparator) {
        this.comparator = comparator;
    }

    public void addCriterion(PerformanceCriterion crit) {
        PerformanceCriterion pc = this.getCriterion(crit.getName());
        if (pc != null) {
            this.removeAveragable(pc);
            LogService.logMessage("Performance criterion '" + crit.getName() + "' was already part of performance vector. Overwritten...", 4);
        }
        this.addAveragable(crit);
    }

    public PerformanceCriterion getCriterion(int index) {
        return (PerformanceCriterion)this.getAveragable(index);
    }

    public PerformanceCriterion getCriterion(String name) {
        return (PerformanceCriterion)this.getAveragable(name);
    }

    public String[] getCriteriaNames() {
        String[] criteriaNames = new String[this.getSize()];
        int i = 0;
        while (i < criteriaNames.length) {
            criteriaNames[i] = this.getCriterion(i).getName();
            ++i;
        }
        return criteriaNames;
    }

    public void setMainCriterionName(String mcName) {
        if (!mcName.equals("first") && this.getAveragable(mcName) == null) {
            LogService.logMessage("Main criterion not found: '" + mcName + "'.", 6);
        }
        this.mainCriterion = mcName;
    }

    public PerformanceCriterion getMainCriterion() {
        if (this.mainCriterion == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        PerformanceCriterion pc = (PerformanceCriterion)this.getAveragable(this.mainCriterion);
        if (pc == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        return pc;
    }

    public int compareTo(Object o) {
        double result = this.comparator.compare(this, (PerformanceVector)o);
        if (result < 0.0) {
            return -1;
        }
        if (result > 0.0) {
            return 1;
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        PerformanceVector av = new PerformanceVector();
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            av.addAveragable((Averagable)avg.clone());
            ++i;
        }
        return av;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(Tools.getLineSeparator()) + "PerformanceVector [");
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            if (this.mainCriterion != null && avg.getName().equals(this.mainCriterion)) {
                result.append(String.valueOf(Tools.getLineSeparator()) + "*****");
            } else {
                result.append(String.valueOf(Tools.getLineSeparator()) + "-----");
            }
            result.append(avg);
            ++i;
        }
        result.append(String.valueOf(Tools.getLineSeparator()) + "]");
        return result.toString();
    }

    public String getExtension() {
        return "per";
    }

    public String getFileDescription() {
        return "performance vector file";
    }

    public void save(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        super.write(out);
        out.close();
    }

    public void initWriting() {
        this.currentValues = new HashMap<String, Double>();
        int i = 0;
        while (i < this.size()) {
            Averagable averagable = this.getAveragable(i);
            this.currentValues.put(averagable.getName(), averagable.getAverage());
            ++i;
        }
    }

    public static class DefaultComparator
    implements PerformanceComparator {
        private static final long serialVersionUID = 8632060851821885142L;
        private double[] criteriaWeights = null;

        public DefaultComparator() {
        }

        public DefaultComparator(double[] criteriaWeights) {
            this.criteriaWeights = criteriaWeights;
        }

        public int compare(PerformanceVector av1, PerformanceVector av2) {
            if (this.criteriaWeights != null) {
                LogService.logMessage("Non null criteria weights are currently not supported for performance vector comparisons!", 4);
                return 0;
            }
            return av1.getMainCriterion().compareTo(av2.getMainCriterion());
        }
    }
}

