/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.operator.performance.AbsoluteError;
import edu.udo.cs.yale.operator.performance.AreaUnderCurve;
import edu.udo.cs.yale.operator.performance.BinaryClassificationPerformance;
import edu.udo.cs.yale.operator.performance.ClassWeightedPerformance;
import edu.udo.cs.yale.operator.performance.CorrelationCriterion;
import edu.udo.cs.yale.operator.performance.MDLCriterion;
import edu.udo.cs.yale.operator.performance.Margin;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.operator.performance.MultiClassificationPerformance;
import edu.udo.cs.yale.operator.performance.NormalizedAbsoluteError;
import edu.udo.cs.yale.operator.performance.PerformanceComparator;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.performance.PredictionAverage;
import edu.udo.cs.yale.operator.performance.PredictionTrendAccuracy;
import edu.udo.cs.yale.operator.performance.RankCorrelation;
import edu.udo.cs.yale.operator.performance.RelativeError;
import edu.udo.cs.yale.operator.performance.RootMeanSquaredError;
import edu.udo.cs.yale.operator.performance.RootRelativeSquaredError;
import edu.udo.cs.yale.operator.performance.SquaredCorrelationCriterion;
import edu.udo.cs.yale.operator.performance.SquaredError;
import edu.udo.cs.yale.operator.performance.WeightedMultiClassPerformance;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLSerialization;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceEvaluator
extends Operator {
    private static final int NUMBER_OF_USER_CRITERIA = 3;
    private static final String[] SIMPLE_CRITERIA_NAMES = new String[]{"absolute_error", "relative_error", "normalized_absolute_error", "root_mean_squared_error", "root_relative_squared_error", "squared_error", "correlation", "squared_correlation", "prediction_average", "AUC", "margin", "prediction_trend_accuracy"};
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{AbsoluteError.class, RelativeError.class, NormalizedAbsoluteError.class, RootMeanSquaredError.class, RootRelativeSquaredError.class, SquaredError.class, CorrelationCriterion.class, SquaredCorrelationCriterion.class, PredictionAverage.class, AreaUnderCurve.class, Margin.class, PredictionTrendAccuracy.class};
    private static String[] allCriteriaNames;
    private static String[] allCriteriaDescriptions;
    private static Map<String, Class> classnameMap;
    private ArrayList<PerformanceCriterion> userCriteria;
    private PerformanceVector currentPerformanceVector = null;

    static {
        LinkedList<String> criteriaNames = new LinkedList<String>();
        LinkedList<String> criteriaDescriptions = new LinkedList<String>();
        criteriaNames.add("first");
        criteriaDescriptions.add("Use the first criterion in the performance vector as main criterion.");
        String[] stringArray = SIMPLE_CRITERIA_NAMES;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String name = stringArray[n];
            criteriaNames.add(name);
            ++n;
        }
        int i = 0;
        while (i < SIMPLE_CRITERIA_CLASSES.length) {
            try {
                criteriaDescriptions.add(((MeasuredPerformance)SIMPLE_CRITERIA_CLASSES[i].newInstance()).getDescription());
            }
            catch (Throwable t) {
                criteriaDescriptions.add("The performance criterion " + SIMPLE_CRITERIA_NAMES[i] + " error.");
            }
            ++i;
        }
        stringArray = MultiClassificationPerformance.NAMES;
        int n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String name = stringArray[n3];
            criteriaNames.add(name);
            ++n3;
        }
        stringArray = MultiClassificationPerformance.DESCRIPTIONS;
        n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String description = stringArray[n3];
            criteriaDescriptions.add(description);
            ++n3;
        }
        stringArray = BinaryClassificationPerformance.NAMES;
        n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String name = stringArray[n3];
            criteriaNames.add(name);
            ++n3;
        }
        stringArray = BinaryClassificationPerformance.DESCRIPTIONS;
        n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String description = stringArray[n3];
            criteriaDescriptions.add(description);
            ++n3;
        }
        stringArray = WeightedMultiClassPerformance.NAMES;
        n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String name = stringArray[n3];
            criteriaNames.add(name);
            ++n3;
        }
        stringArray = WeightedMultiClassPerformance.DESCRIPTIONS;
        n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String description = stringArray[n3];
            criteriaDescriptions.add(description);
            ++n3;
        }
        stringArray = RankCorrelation.NAMES;
        n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String name = stringArray[n3];
            criteriaNames.add(name);
            ++n3;
        }
        stringArray = RankCorrelation.DESCRIPTIONS;
        n3 = 0;
        n2 = stringArray.length;
        while (n3 < n2) {
            String description = stringArray[n3];
            criteriaDescriptions.add(description);
            ++n3;
        }
        allCriteriaNames = new String[criteriaNames.size()];
        criteriaNames.toArray(allCriteriaNames);
        allCriteriaDescriptions = new String[criteriaDescriptions.size()];
        criteriaDescriptions.toArray(allCriteriaDescriptions);
        classnameMap = new HashMap<String, Class>();
        i = 0;
        while (i < SIMPLE_CRITERIA_NAMES.length) {
            classnameMap.put(SIMPLE_CRITERIA_NAMES[i], SIMPLE_CRITERIA_CLASSES[i]);
            XMLSerialization.getXMLSerialization().addAlias(SIMPLE_CRITERIA_NAMES[i], SIMPLE_CRITERIA_CLASSES[i]);
            ++i;
        }
        XMLSerialization.getXMLSerialization().addAlias("binary_classification_performance", BinaryClassificationPerformance.class);
        XMLSerialization.getXMLSerialization().addAlias("mdl", MDLCriterion.class);
        XMLSerialization.getXMLSerialization().addAlias("multi_classification_performance", MultiClassificationPerformance.class);
        XMLSerialization.getXMLSerialization().addAlias("weighted_multi_classification_performance", WeightedMultiClassPerformance.class);
        XMLSerialization.getXMLSerialization().addAlias("rank_correlation", RankCorrelation.class);
    }

    public PerformanceEvaluator(OperatorDescription description) {
        super(description);
        int i = 0;
        while (i < SIMPLE_CRITERIA_NAMES.length) {
            this.addPerformanceValue(SIMPLE_CRITERIA_NAMES[i], allCriteriaDescriptions[i]);
            ++i;
        }
        i = 0;
        while (i < MultiClassificationPerformance.NAMES.length) {
            this.addPerformanceValue(MultiClassificationPerformance.NAMES[i], MultiClassificationPerformance.DESCRIPTIONS[i]);
            ++i;
        }
        i = 0;
        while (i < BinaryClassificationPerformance.NAMES.length) {
            this.addPerformanceValue(BinaryClassificationPerformance.NAMES[i], BinaryClassificationPerformance.DESCRIPTIONS[i]);
            ++i;
        }
        i = 0;
        while (i < WeightedMultiClassPerformance.NAMES.length) {
            this.addPerformanceValue(WeightedMultiClassPerformance.NAMES[i], WeightedMultiClassPerformance.DESCRIPTIONS[i]);
            ++i;
        }
        i = 0;
        while (i < RankCorrelation.NAMES.length) {
            this.addPerformanceValue(RankCorrelation.NAMES[i], RankCorrelation.DESCRIPTIONS[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.addPerformanceValue("user:" + (i + 1), "The user defined performance criterion " + i);
            ++i;
        }
    }

    private void addPerformanceValue(final String name, String description) {
        this.addValue(new Value(name, description){

            public double getValue() {
                if (PerformanceEvaluator.this.currentPerformanceVector == null) {
                    return Double.NaN;
                }
                PerformanceCriterion c = null;
                if (name.startsWith("user:")) {
                    int index = Integer.parseInt(name.substring(5)) - 1;
                    c = (PerformanceCriterion)PerformanceEvaluator.this.userCriteria.get(index);
                } else {
                    c = PerformanceEvaluator.this.currentPerformanceVector.getCriterion(name);
                }
                if (c != null) {
                    return c.getAverage();
                }
                return Double.NaN;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PerformanceVector initialisePerformanceVector(ExampleSet testSet, PerformanceVector performanceCriteria, List<PerformanceCriterion> givenCriteria) throws OperatorException {
        int i;
        givenCriteria.clear();
        if (performanceCriteria == null) {
            performanceCriteria = new PerformanceVector();
        } else {
            i = 0;
            while (i < performanceCriteria.getSize()) {
                givenCriteria.add(performanceCriteria.getCriterion(i));
                ++i;
            }
        }
        this.userCriteria = new ArrayList();
        i = 0;
        while (i < SIMPLE_CRITERIA_NAMES.length) {
            if (this.checkCriterionName(SIMPLE_CRITERIA_NAMES[i])) {
                try {
                    performanceCriteria.addCriterion((PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance());
                }
                catch (InstantiationException e) {
                    LogService.logMessage("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ".", 6);
                }
                catch (IllegalAccessException e) {
                    LogService.logMessage("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ".", 6);
                }
            }
            ++i;
        }
        i = 0;
        while (i < MultiClassificationPerformance.NAMES.length) {
            if (this.checkCriterionName(MultiClassificationPerformance.NAMES[i])) {
                performanceCriteria.addCriterion(new MultiClassificationPerformance(i));
            }
            ++i;
        }
        i = 0;
        while (i < BinaryClassificationPerformance.NAMES.length) {
            if (this.checkCriterionName(BinaryClassificationPerformance.NAMES[i])) {
                performanceCriteria.addCriterion(new BinaryClassificationPerformance(i));
            }
            ++i;
        }
        i = 0;
        while (i < WeightedMultiClassPerformance.NAMES.length) {
            if (this.checkCriterionName(WeightedMultiClassPerformance.NAMES[i])) {
                performanceCriteria.addCriterion(new WeightedMultiClassPerformance(i));
            }
            ++i;
        }
        i = 0;
        while (i < RankCorrelation.NAMES.length) {
            if (this.checkCriterionName(RankCorrelation.NAMES[i])) {
                performanceCriteria.addCriterion(new RankCorrelation(i));
            }
            ++i;
        }
        for (Object[] keyValue : this.getParameterList("additional_performance_criteria")) {
            String className = (String)keyValue[0];
            String parameter = (String)keyValue[1];
            Class criterionClass = null;
            try {
                criterionClass = Tools.classForName(className);
                if (!PerformanceCriterion.class.isAssignableFrom(criterionClass)) {
                    throw new UserError((Operator)this, 914, new Object[]{criterionClass, PerformanceCriterion.class});
                }
                PerformanceCriterion c = null;
                if (parameter != null && parameter.trim().length() > 0) {
                    Constructor constructor = criterionClass.getConstructor(String.class);
                    c = (PerformanceCriterion)constructor.newInstance(parameter);
                } else {
                    c = (PerformanceCriterion)criterionClass.newInstance();
                }
                if (!(c instanceof MeasuredPerformance)) {
                    throw new UserError((Operator)this, 903, new Object[0]);
                }
                performanceCriteria.addCriterion(c);
                this.userCriteria.add(c);
            }
            catch (ClassNotFoundException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{className, e});
            }
            catch (InstantiationException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{className, e});
            }
            catch (IllegalAccessException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{className, e});
            }
            catch (NoSuchMethodException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{className, e});
            }
            catch (InvocationTargetException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{className, e});
            }
        }
        if (performanceCriteria.size() == 0) {
            LogService.logMessage(String.valueOf(this.getName()) + ": No performance criterion defined! Please define proper parameters. For now, trying...", 4);
            Attribute labelAttribute = testSet.getAttributes().getLabel();
            if (labelAttribute == null) {
                LogService.logMessage(String.valueOf(this.getName()) + ": Not possible to determine type of label. Error.", 4);
                throw new UserError(this, 910);
            }
            if (labelAttribute.isNominal()) {
                LogService.logMessage(String.valueOf(this.getName()) + ": label is nominal -- using 'accuracy'.", 4);
                performanceCriteria.addCriterion(new MultiClassificationPerformance(0));
                performanceCriteria.setMainCriterionName("accuracy");
            } else {
                LogService.logMessage(String.valueOf(this.getName()) + ": label is numerical -- using 'root mean squared error'.", 4);
                performanceCriteria.addCriterion(new SquaredError());
                performanceCriteria.setMainCriterionName("root_mean_squared_error");
            }
        } else {
            performanceCriteria.setMainCriterionName(this.getParameterAsString("main_criterion"));
        }
        String comparatorClass = this.getParameterAsString("comparator_class");
        if (comparatorClass == null) {
            performanceCriteria.setComparator(new PerformanceVector.DefaultComparator());
            return performanceCriteria;
        }
        try {
            Class pcClass = Tools.classForName(comparatorClass);
            if (!PerformanceComparator.class.isAssignableFrom(pcClass)) {
                throw new UserError((Operator)this, 914, new Object[]{pcClass, PerformanceComparator.class});
            }
            performanceCriteria.setComparator((PerformanceComparator)pcClass.newInstance());
            return performanceCriteria;
        }
        catch (Throwable e) {
            throw new UserError((Operator)this, e, 904, new Object[]{comparatorClass, e});
        }
    }

    private boolean checkCriterionName(String name) throws UndefinedParameterError {
        String mainCriterionName = this.getParameterAsString("main_criterion");
        if (name != null && name.trim().length() != 0 && !name.equals("first") && name.equals(mainCriterionName)) {
            return true;
        }
        return this.getParameterAsBoolean(name);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet testSet = this.getInput(ExampleSet.class);
        PerformanceVector inputPerformance = null;
        try {
            inputPerformance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        try {
            PerformanceVector performance = this.evaluate(testSet, inputPerformance);
            return new IOObject[]{performance};
        }
        catch (UserError e) {
            e.setOperator(this);
            throw e;
        }
    }

    protected PerformanceVector evaluate(ExampleSet testSet, PerformanceVector inputPerformance) throws OperatorException {
        LinkedList<PerformanceCriterion> givenCriteria = new LinkedList<PerformanceCriterion>();
        this.currentPerformanceVector = this.initialisePerformanceVector(testSet, inputPerformance, givenCriteria);
        PerformanceEvaluator.evaluate(this, testSet, this.currentPerformanceVector, givenCriteria, this.getParameterAsBoolean("skip_undefined_labels"));
        return this.currentPerformanceVector;
    }

    public static void evaluate(PerformanceEvaluator evaluator, ExampleSet testSet, PerformanceVector performanceCriteria, List<PerformanceCriterion> givenCriteria, boolean skipUndefinedLabels) throws OperatorException {
        if (testSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)evaluator, 105, new Object[0]);
        }
        if (testSet.getAttributes().getPredictedLabel() == null) {
            throw new UserError((Operator)evaluator, 107, new Object[0]);
        }
        double[] weights = null;
        Attribute label = testSet.getAttributes().getLabel();
        if (evaluator != null && label.isNominal() && evaluator.isParameterSet("class_weights")) {
            weights = new double[label.getMapping().size()];
            int i = 0;
            while (i < weights.length) {
                weights[i] = 1.0;
                ++i;
            }
            List classWeights = evaluator.getParameterList("class_weights");
            for (Object[] classWeightArray : classWeights) {
                String className = (String)classWeightArray[0];
                double classWeight = (Double)classWeightArray[1];
                int index = label.getMapping().mapString(className);
                weights[index] = classWeight;
            }
            LinkedList<Double> weightList = new LinkedList<Double>();
            double[] dArray = weights;
            int n = 0;
            int n2 = dArray.length;
            while (n < n2) {
                double d = dArray[n];
                weightList.add(d);
                ++n;
            }
            LogService.logMessage(String.valueOf(evaluator.getName()) + ": used class weights --> " + weightList, 2);
        }
        int pc = 0;
        while (pc < performanceCriteria.size()) {
            PerformanceCriterion c = performanceCriteria.getCriterion(pc);
            if (!givenCriteria.contains(c)) {
                if (!(c instanceof MeasuredPerformance)) {
                    throw new UserError((Operator)evaluator, 903, new Object[0]);
                }
                ((MeasuredPerformance)c).startCounting(testSet);
                if (c instanceof ClassWeightedPerformance && weights != null) {
                    ((ClassWeightedPerformance)((Object)c)).setWeights(weights);
                }
            }
            ++pc;
        }
        for (Example example : testSet) {
            if (skipUndefinedLabels && (Double.isNaN(example.getLabel()) || Double.isNaN(example.getPredictedLabel()))) continue;
            int pc2 = 0;
            while (pc2 < performanceCriteria.size()) {
                PerformanceCriterion criterion = performanceCriteria.getCriterion(pc2);
                if (!givenCriteria.contains(criterion) && criterion instanceof MeasuredPerformance) {
                    ((MeasuredPerformance)criterion).countExample(example);
                }
                ++pc2;
            }
            if (evaluator == null) continue;
            evaluator.checkForStop();
        }
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory("main_criterion", "The criterion used for comparing performance vectors.", allCriteriaNames, allCriteriaNames[0]);
        type.setExpert(false);
        types.add(type);
        int i = 0;
        while (i < SIMPLE_CRITERIA_NAMES.length) {
            type = new ParameterTypeBoolean(SIMPLE_CRITERIA_NAMES[i], allCriteriaDescriptions[i + 1], false);
            type.setExpert(false);
            types.add(type);
            ++i;
        }
        i = 0;
        while (i < MultiClassificationPerformance.NAMES.length) {
            type = new ParameterTypeBoolean(MultiClassificationPerformance.NAMES[i], MultiClassificationPerformance.DESCRIPTIONS[i], false);
            type.setExpert(false);
            types.add(type);
            ++i;
        }
        i = 0;
        while (i < BinaryClassificationPerformance.NAMES.length) {
            type = new ParameterTypeBoolean(BinaryClassificationPerformance.NAMES[i], BinaryClassificationPerformance.DESCRIPTIONS[i], false);
            type.setExpert(false);
            types.add(type);
            ++i;
        }
        i = 0;
        while (i < WeightedMultiClassPerformance.NAMES.length) {
            type = new ParameterTypeBoolean(WeightedMultiClassPerformance.NAMES[i], WeightedMultiClassPerformance.DESCRIPTIONS[i], false);
            type.setExpert(false);
            types.add(type);
            ++i;
        }
        i = 0;
        while (i < RankCorrelation.NAMES.length) {
            type = new ParameterTypeBoolean(RankCorrelation.NAMES[i], RankCorrelation.DESCRIPTIONS[i], false);
            type.setExpert(false);
            types.add(type);
            ++i;
        }
        types.add(new ParameterTypeList("class_weights", "The weights for all classes (first column: class name, second column: weight), empty: using 1 for all classes.", new ParameterTypeDouble("weight", "The weight for the specified class.", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        types.add(new ParameterTypeBoolean("skip_undefined_labels", "If set to true, examples with undefined labels are skipped.", false));
        types.add(new ParameterTypeString("comparator_class", "Fully qualified classname of the PerformanceComparator implementation.", true));
        types.add(new ParameterTypeList("additional_performance_criteria", "List of classes that implement edu.udo.cs.yale.operator.performance.PerformanceCriterion.", new ParameterTypeString("optional_parameters", "The key must be a fully qualified classname and the value may be a string that is passed to the constructor of this class.", "")));
        return types;
    }
}

