/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.viewer.ConfusionMatrixViewer;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.Averagable;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class MultiClassificationPerformance
extends MeasuredPerformance {
    public static final int UNDEFINED = -1;
    public static final int ACCURACY = 0;
    public static final int ERROR = 1;
    public static final int KAPPA = 2;
    public static final String[] NAMES = new String[]{"accuracy", "classification_error", "kappa"};
    public static final String[] DESCRIPTIONS = new String[]{"Relative number of correctly classified examples", "Relative number of misclassified examples", "The kappa statistics for the classification"};
    private int[][] counter;
    private String[] classNames;
    private int type = 0;

    public MultiClassificationPerformance() {
        this(-1);
    }

    public MultiClassificationPerformance(int type) {
        this.type = type;
    }

    public MultiClassificationPerformance(MultiClassificationPerformance m) {
        super(m);
        this.type = m.type;
        this.classNames = new String[m.classNames.length];
        int i = 0;
        while (i < this.classNames.length) {
            this.classNames[i] = m.classNames[i];
            ++i;
        }
        this.counter = new int[m.counter.length][m.counter.length];
        i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                this.counter[i][j] = m.counter[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static MultiClassificationPerformance newInstance(String name) {
        int i = 0;
        while (i < NAMES.length) {
            if (NAMES[i].equals(name)) {
                return new MultiClassificationPerformance(i);
            }
            ++i;
        }
        return null;
    }

    public int getExampleCount() {
        int total = 0;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                total += this.counter[i][j];
                ++j;
            }
            ++i;
        }
        return total;
    }

    public void startCounting(ExampleSet eSet) {
        Attribute label = eSet.getAttributes().getLabel();
        List<String> values = label.getMapping().getValues();
        this.counter = new int[values.size()][values.size()];
        this.classNames = new String[values.size()];
        Iterator i = values.iterator();
        int n = 0;
        while (i.hasNext()) {
            this.classNames[n++] = (String)i.next();
        }
    }

    public void countExample(Example example) {
        int label = (int)example.getLabel();
        int plabel = (int)example.getPredictedLabel();
        int[] nArray = this.counter[label];
        int n = plabel;
        nArray[n] = nArray[n] + 1;
    }

    public double getMikroAverage() {
        int diagonal = 0;
        int total = 0;
        int i = 0;
        while (i < this.counter.length) {
            diagonal += this.counter[i][i];
            int j = 0;
            while (j < this.counter[i].length) {
                total += this.counter[i][j];
                ++j;
            }
            ++i;
        }
        if (total == 0) {
            return Double.NaN;
        }
        double accuracy = (double)diagonal / (double)total;
        switch (this.type) {
            case 0: {
                return accuracy;
            }
            case 1: {
                return 1.0 - accuracy;
            }
            case 2: {
                double pa = accuracy;
                double pe = 0.0;
                int i2 = 0;
                while (i2 < this.counter.length) {
                    double row = 0.0;
                    double column = 0.0;
                    int j = 0;
                    while (j < this.counter[i2].length) {
                        row += (double)this.counter[i2][j];
                        column += (double)this.counter[j][i2];
                        ++j;
                    }
                    pe += row * column / Math.pow(total, this.counter.length);
                    ++i2;
                }
                return (pa - pe) / (1.0 - pe);
            }
        }
        throw new RuntimeException("Unknown type " + this.type + " for multi class performance criterion!");
    }

    public boolean formatPercent() {
        return this.type != 2;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public double getFitness() {
        if (this.type == 1) {
            return 1.0 - this.getAverage();
        }
        return this.getAverage();
    }

    public double getMaxFitness() {
        return 1.0;
    }

    public void buildSingleAverage(Averagable performance) {
        MultiClassificationPerformance other = (MultiClassificationPerformance)performance;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                int[] nArray = this.counter[i];
                int n = j;
                nArray[n] = nArray[n] + other.counter[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Component getVisualizationComponent(IOContainer ioContainer) {
        return new ConfusionMatrixViewer(super.toString(), this.classNames, this.counter);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(String.valueOf(Tools.getLineSeparator()) + "ConfusionMatrix:" + Tools.getLineSeparator() + "True:");
        int i = 0;
        while (i < this.counter.length) {
            result.append("\t" + this.classNames[i]);
            ++i;
        }
        i = 0;
        while (i < this.counter.length) {
            result.append(String.valueOf(Tools.getLineSeparator()) + this.classNames[i] + ":");
            int j = 0;
            while (j < this.counter[i].length) {
                result.append("\t" + this.counter[j][i]);
                ++j;
            }
            ++i;
        }
        return result.toString();
    }
}

