/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.operator.performance.MinMaxCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMaxWrapper
extends Operator {
    public MinMaxWrapper(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        PerformanceVector performanceVector = this.getInput(PerformanceVector.class);
        PerformanceVector result = new PerformanceVector();
        int i = 0;
        while (i < performanceVector.size()) {
            PerformanceCriterion crit = performanceVector.getCriterion(i);
            if (crit instanceof MeasuredPerformance) {
                result.addCriterion(new MinMaxCriterion((MeasuredPerformance)crit, this.getParameterAsDouble("minimum_weight")));
            }
            ++i;
        }
        result.setMainCriterionName(performanceVector.getMainCriterion().getName());
        return new IOObject[]{result};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("minimum_weight", "Defines the weight for the minimum fitness agains the average fitness", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

