/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;
import java.util.Iterator;

public class Margin
extends MeasuredPerformance {
    private double margin = Double.NaN;
    private int counter = 1;

    public Margin() {
    }

    public Margin(Margin m) {
        super(m);
        this.margin = m.margin;
        this.counter = m.counter;
    }

    public void startCounting(ExampleSet exampleSet) throws OperatorException {
        Iterator reader = exampleSet.iterator();
        this.margin = 1.0;
        Attribute labelAttr = exampleSet.getAttributes().getLabel();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            int trueLabel = (int)example.getLabel();
            double confidence = example.getConfidence(labelAttr.getMapping().mapIndex(trueLabel));
            if (!(confidence < this.margin)) continue;
            this.margin = confidence;
        }
    }

    public void countExample(Example example) {
    }

    public int getExampleCount() {
        return 1;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getMikroAverage() {
        return this.margin / (double)this.counter;
    }

    public double getFitness() {
        return this.getAverage();
    }

    public String getName() {
        return "margin";
    }

    public String getDescription() {
        return "The margin of a classifier, defined as the minimal confidence for the correct label.";
    }

    public void buildSingleAverage(Averagable performance) {
        Margin other = (Margin)performance;
        this.counter += other.counter;
        this.margin += other.margin;
    }

    public String toString() {
        return super.toString();
    }
}

