/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;

public class MDLCriterion
extends MeasuredPerformance {
    public static final String[] DIRECTIONS = new String[]{"minimization", "maximization"};
    public static final int MINIMIZATION = 0;
    public static final int MAXIMIZATION = 1;
    private int length;
    private int counter = 1;
    private int direction = 0;

    public MDLCriterion() {
    }

    public MDLCriterion(int direction) {
        this();
        this.direction = direction;
    }

    public MDLCriterion(MDLCriterion mdl) {
        super(mdl);
        this.length = mdl.length;
        this.counter = mdl.counter;
        this.direction = mdl.direction;
    }

    public String getName() {
        return "number_of_attributes";
    }

    public String getDescription() {
        return "Measures the length of an example set (i.e. the number of attributes).";
    }

    public void startCounting(ExampleSet eSet) throws OperatorException {
        super.startCounting(eSet);
        this.length = eSet instanceof AttributeWeightedExampleSet ? ((AttributeWeightedExampleSet)eSet).getNumberOfUsedAttributes() : eSet.getAttributes().size();
    }

    public int getExampleCount() {
        return 1;
    }

    public void countExample(Example example) {
    }

    public double getFitness() {
        switch (this.direction) {
            case 0: {
                return -1.0 * (double)this.length / (double)this.counter;
            }
            case 1: {
                return (double)this.length / (double)this.counter;
            }
        }
        return Double.NaN;
    }

    public double getMikroAverage() {
        return (double)this.length / (double)this.counter;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void buildSingleAverage(Averagable averagable) {
        MDLCriterion other = (MDLCriterion)averagable;
        this.length += other.length;
        ++this.counter;
    }
}

