/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.tools.math.Averagable;

public class EstimatedPerformance
extends PerformanceCriterion {
    private String name;
    private double value;
    private int exampleCount = 1;
    private boolean minimizeForFitness;

    public EstimatedPerformance() {
    }

    public EstimatedPerformance(EstimatedPerformance ep) {
        super(ep);
        this.name = ep.name;
        this.minimizeForFitness = ep.minimizeForFitness;
        this.exampleCount = ep.exampleCount;
        this.value = ep.value;
    }

    public EstimatedPerformance(String name, double value, int numberOfExamples, boolean minimizeForFitness) {
        this.name = name;
        this.setMikroAverage(value, numberOfExamples);
        this.minimizeForFitness = minimizeForFitness;
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void setMikroAverage(double value, int numberOfExamples) {
        this.value = value * (double)numberOfExamples;
        this.exampleCount = numberOfExamples;
    }

    public double getMikroAverage() {
        return this.value / (double)this.exampleCount;
    }

    public double getFitness() {
        if (this.minimizeForFitness) {
            return -1.0 * this.getAverage();
        }
        return this.getAverage();
    }

    public String getName() {
        return this.name;
    }

    public void buildSingleAverage(Averagable performance) {
        EstimatedPerformance other = (EstimatedPerformance)performance;
        this.exampleCount += other.exampleCount;
        this.value += other.value;
    }
}

