/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;

public class CorrelationCriterion
extends MeasuredPerformance {
    private int exampleCount = 0;
    private double sumLabel;
    private double sumPredict;
    private double sumLabelPredict;
    private double sumLabelSqr;
    private double sumPredictSqr;

    public CorrelationCriterion() {
    }

    public CorrelationCriterion(CorrelationCriterion sc) {
        super(sc);
        this.sumLabelPredict = sc.sumLabelPredict;
        this.sumLabelSqr = sc.sumLabelSqr;
        this.sumPredictSqr = sc.sumPredictSqr;
        this.sumLabel = sc.sumLabel;
        this.sumPredict = sc.sumPredict;
        this.exampleCount = sc.exampleCount;
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public double getMaxFitness() {
        return 1.0;
    }

    public void countExample(Example example) {
        double plabel;
        double label = example.getLabel();
        double prod = label * (plabel = example.getPredictedLabel());
        if (!Double.isNaN(prod)) {
            this.sumLabelPredict += prod;
            this.sumLabel += label;
            this.sumLabelSqr += label * label;
            this.sumPredict += plabel;
            this.sumPredictSqr += plabel * plabel;
            ++this.exampleCount;
        }
    }

    public String getDescription() {
        return "Returns the correlation coefficient between the label and predicted label.";
    }

    public double getMikroAverage() {
        double r = ((double)this.exampleCount * this.sumLabelPredict - this.sumLabel * this.sumPredict) / Math.sqrt(((double)this.exampleCount * this.sumLabelSqr - this.sumLabel * this.sumLabel) * ((double)this.exampleCount * this.sumPredictSqr - this.sumPredict * this.sumPredict));
        return r;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void startCounting(ExampleSet eset) throws OperatorException {
        super.startCounting(eset);
        this.exampleCount = 0;
        this.sumPredictSqr = 0.0;
        this.sumLabelSqr = 0.0;
        this.sumPredict = 0.0;
        this.sumLabel = 0.0;
        this.sumLabelPredict = 0.0;
    }

    public void buildSingleAverage(Averagable performance) {
        CorrelationCriterion other = (CorrelationCriterion)performance;
        this.sumLabelPredict += other.sumLabelPredict;
        this.sumLabelSqr += other.sumLabelSqr;
        this.sumPredictSqr += other.sumPredictSqr;
        this.sumLabel += other.sumLabel;
        this.sumPredict += other.sumPredict;
        this.exampleCount += other.exampleCount;
    }

    public double getFitness() {
        return this.getAverage();
    }

    public String getName() {
        return "correlation";
    }
}

