/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.viewer.ConfusionMatrixViewer;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.Averagable;
import java.awt.Component;

public class BinaryClassificationPerformance
extends MeasuredPerformance {
    public static final int PRECISION = 0;
    public static final int RECALL = 1;
    public static final int LIFT = 2;
    public static final int FALLOUT = 3;
    public static final int F_MEASURE = 4;
    public static final int FALSE_POSITIVE = 5;
    public static final int FALSE_NEGATIVE = 6;
    public static final int TRUE_POSITIVE = 7;
    public static final int TRUE_NEGATIVE = 8;
    private static final int NEGATIVE = 0;
    private static final int POSITIVE = 1;
    public static final String[] NAMES = new String[]{"precision", "recall", "lift", "fallout", "f_measure", "false_positive", "false_negative", "true_positive", "true_negative"};
    public static final String[] DESCRIPTIONS = new String[]{"Relative number of correctly as positive classified examples among all examples classified as positive", "Relative number of correctly as positive classified examples among all positive examples", "The lift of the positive class", "Relative number of incorrectly as positive classified examples among all negative examples", "Combination of precision and recall: f=2pr/(p+r)", "Absolute number of incorrectly as positive classified examples", "Absolute number of incorrectly as negative classified examples", "Absolute number of correctly as positive classified examples", "Absolute number of correctly as negative classified examples"};
    private int type = 0;
    private int negative;
    private int[][] counter = new int[2][2];
    private String positiveClassName = "";
    private String negativeClassName = "";

    public BinaryClassificationPerformance() {
        this.negative = -1;
        this.type = -1;
    }

    public BinaryClassificationPerformance(BinaryClassificationPerformance o) {
        super(o);
        this.type = o.type;
        this.negative = o.negative;
        this.counter = new int[2][2];
        this.counter[0][0] = o.counter[0][0];
        this.counter[1][0] = o.counter[1][0];
        this.counter[0][1] = o.counter[0][1];
        this.counter[1][1] = o.counter[1][1];
    }

    public BinaryClassificationPerformance(int type) {
        this(type, 0);
    }

    public BinaryClassificationPerformance(int type, int negative) {
        this.type = type;
        this.negative = negative;
    }

    public BinaryClassificationPerformance(int type, int[][] counter) {
        this.type = type;
        this.counter[0][0] = counter[0][0];
        this.counter[0][1] = counter[0][1];
        this.counter[1][0] = counter[1][0];
        this.counter[1][1] = counter[1][1];
    }

    public static BinaryClassificationPerformance newInstance(String name) {
        int i = 0;
        while (i < NAMES.length) {
            if (NAMES[i].equals(name)) {
                return new BinaryClassificationPerformance(i);
            }
            ++i;
        }
        return null;
    }

    public int getExampleCount() {
        return this.counter[1][1] + this.counter[0][1] + this.counter[1][0] + this.counter[0][0];
    }

    public void startCounting(ExampleSet eSet) throws OperatorException {
        Attribute label = eSet.getAttributes().getLabel();
        if (!label.isNominal() || label.getMapping().size() != 2) {
            throw new UserError(null, 118, new Object[]{"'" + label.getName() + "'", label.getMapping().getValues().size(), "2 for calculation of '" + this.getName() + "'"});
        }
        this.negativeClassName = label.getMapping().getNegativeString();
        this.positiveClassName = label.getMapping().getPositiveString();
        this.counter = new int[2][2];
    }

    public void countExample(Example example) {
        int label = example.getLabel() == (double)this.negative ? 0 : 1;
        int plabel = example.getPredictedLabel() == (double)this.negative ? 0 : 1;
        int[] nArray = this.counter[label];
        int n = plabel;
        nArray[n] = nArray[n] + 1;
    }

    public double getMikroAverage() {
        double x = 0.0;
        double y = 0.0;
        switch (this.type) {
            case 0: {
                x = this.counter[1][1];
                y = this.counter[1][1] + this.counter[0][1];
                break;
            }
            case 1: {
                x = this.counter[1][1];
                y = this.counter[1][1] + this.counter[1][0];
                break;
            }
            case 2: {
                x = (double)this.counter[1][1] / (double)(this.counter[1][1] + this.counter[1][0]);
                y = (double)(this.counter[1][1] + this.counter[0][1]) / (double)(this.counter[1][1] + this.counter[1][0] + this.counter[0][1] + this.counter[0][0]);
                break;
            }
            case 3: {
                x = this.counter[0][1];
                y = this.counter[0][1] + this.counter[0][0];
                break;
            }
            case 4: {
                x = this.counter[1][1];
                x *= x;
                y = (x *= 2.0) + (double)(this.counter[1][1] * this.counter[1][0]) + (double)(this.counter[1][1] * this.counter[0][1]);
                break;
            }
            case 6: {
                x = this.counter[1][0];
                y = 1.0;
                break;
            }
            case 5: {
                x = this.counter[0][1];
                y = 1.0;
                break;
            }
            case 8: {
                x = this.counter[0][0];
                y = 1.0;
                break;
            }
            case 7: {
                x = this.counter[1][1];
                y = 1.0;
                break;
            }
            default: {
                throw new RuntimeException("Illegal value for type in BinaryClassificationPerformance: " + this.type);
            }
        }
        if (y == 0.0) {
            return Double.NaN;
        }
        return x / y;
    }

    public double getFitness() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                return this.getAverage();
            }
            case 3: 
            case 5: 
            case 6: {
                if (this.getAverage() == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                return 1.0 / this.getAverage();
            }
        }
        throw new RuntimeException("Illegal value for type in BinaryClassificationPerformance: " + this.type);
    }

    public double getMaxFitness() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 4: {
                return 1.0;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Double.POSITIVE_INFINITY;
            }
        }
        throw new RuntimeException("Illegal value for type in BinaryClassificationPerformance: " + this.type);
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public boolean formatPercent() {
        switch (this.type) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public void buildSingleAverage(Averagable performance) {
        BinaryClassificationPerformance other = (BinaryClassificationPerformance)performance;
        if (this.type != other.type) {
            throw new RuntimeException("Cannot build average of different error types (" + NAMES[this.type] + "/" + NAMES[other.type] + ").");
        }
        if (this.negative != other.negative) {
            throw new RuntimeException("Cannot build average for different negative classes (" + this.negative + "/" + other.negative + ").");
        }
        int[] nArray = this.counter[0];
        nArray[0] = nArray[0] + other.counter[0][0];
        int[] nArray2 = this.counter[0];
        nArray2[1] = nArray2[1] + other.counter[0][1];
        int[] nArray3 = this.counter[1];
        nArray3[0] = nArray3[0] + other.counter[1][0];
        int[] nArray4 = this.counter[1];
        nArray4[1] = nArray4[1] + other.counter[1][1];
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (positive class: " + this.positiveClassName + ")");
        result.append(String.valueOf(Tools.getLineSeparator()) + "ConfusionMatrix:" + Tools.getLineSeparator() + "True:");
        result.append("\t" + this.negativeClassName);
        result.append("\t" + this.positiveClassName);
        result.append(String.valueOf(Tools.getLineSeparator()) + this.negativeClassName + ":");
        result.append("\t" + this.counter[0][0]);
        result.append("\t" + this.counter[1][0]);
        result.append(String.valueOf(Tools.getLineSeparator()) + this.positiveClassName + ":");
        result.append("\t" + this.counter[0][1]);
        result.append("\t" + this.counter[1][1]);
        return result.toString();
    }

    public Component getVisualizationComponent(IOContainer ioContainer) {
        return new ConfusionMatrixViewer(String.valueOf(super.toString()) + " (positive class: " + this.positiveClassName + ")", new String[]{this.negativeClassName, this.positiveClassName}, this.counter);
    }
}

