/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.performance.MDLCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeCounter
extends Operator {
    private double lastCount = Double.NaN;

    public AttributeCounter(OperatorDescription description) {
        super(description);
        this.addValue(new Value("attributes", "The currently selected number of attributes."){

            public double getValue() {
                return AttributeCounter.this.lastCount;
            }
        });
    }

    private PerformanceVector count(ExampleSet exampleSet, PerformanceVector performanceCriteria) throws OperatorException {
        if (performanceCriteria == null) {
            performanceCriteria = new PerformanceVector();
        }
        MDLCriterion mdlCriterion = new MDLCriterion(this.getParameterAsInt("optimization_direction"));
        mdlCriterion.startCounting(exampleSet);
        this.lastCount = mdlCriterion.getAverage();
        performanceCriteria.addCriterion(mdlCriterion);
        return performanceCriteria;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        PerformanceVector inputPerformance = null;
        try {
            inputPerformance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        PerformanceVector performance = this.count(exampleSet, inputPerformance);
        return new IOObject[]{performance};
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("optimization_direction", "Indicates if the fitness should for maximal or minimal number of features.", MDLCriterion.DIRECTIONS, 0));
        return types;
    }
}

