/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;
import edu.udo.cs.yale.tools.math.ROCDataGenerator;
import java.util.List;

public class AreaUnderCurve
extends MeasuredPerformance {
    private double auc = Double.NaN;
    private int counter = 1;
    private String positiveClassName = null;

    public AreaUnderCurve() {
    }

    public AreaUnderCurve(AreaUnderCurve aucObject) {
        super(aucObject);
        this.auc = aucObject.auc;
        this.counter = aucObject.counter;
        this.positiveClassName = aucObject.positiveClassName;
    }

    public void startCounting(ExampleSet exampleSet) throws OperatorException {
        ROCDataGenerator rocDataGenerator = new ROCDataGenerator(1.0, 1.0);
        List<double[]> rocData = rocDataGenerator.createROCDataList(exampleSet);
        this.auc = rocDataGenerator.calculateAUC(rocData);
        this.positiveClassName = exampleSet.getAttributes().getLabel().getMapping().getPositiveString();
    }

    public void countExample(Example example) {
    }

    public int getExampleCount() {
        return 1;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getMikroAverage() {
        return this.auc / (double)this.counter;
    }

    public double getFitness() {
        return this.getAverage();
    }

    public String getName() {
        return "AUC";
    }

    public String getDescription() {
        return "The area under a ROC curve. Given example weights are also considered.";
    }

    public void buildSingleAverage(Averagable performance) {
        AreaUnderCurve other = (AreaUnderCurve)performance;
        this.counter += other.counter;
        this.auc += other.auc;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (positive class: " + this.positiveClassName + ")";
    }
}

