/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
implements Cloneable {
    private SortedMap<String, Object> keyToValueMap = new TreeMap<String, Object>();
    private SortedMap<String, ParameterType> keyToTypeMap = new TreeMap<String, ParameterType>();

    public Parameters() {
    }

    public Parameters(List<ParameterType> parameterTypes) {
        for (ParameterType type : parameterTypes) {
            this.keyToTypeMap.put(type.getKey(), type);
        }
    }

    public void copy(Parameters parameters) {
        TreeMap<String, Object> newKey2ValueMap = new TreeMap<String, Object>();
        TreeMap<String, ParameterType> newKey2TypeMap = new TreeMap<String, ParameterType>();
        for (String key : this.keyToTypeMap.keySet()) {
            ParameterType newType = (ParameterType)parameters.keyToTypeMap.get(key);
            if (newType == null) {
                throw new NullPointerException("Error during copying a parameters object: the new parameters does not contain '" + key + "'!");
            }
            newKey2TypeMap.put(key, newType);
        }
        for (String key : this.keyToValueMap.keySet()) {
            try {
                Object newValue = parameters.getParameter(key);
                newKey2ValueMap.put(key, newValue);
            }
            catch (UndefinedParameterError e) {
                LogService.logMessage("Parameter '" + key + "' is not set and has no default value: using empty parameter value for copied parameters.", 6);
            }
        }
        this.keyToValueMap = newKey2ValueMap;
        this.keyToTypeMap = newKey2TypeMap;
    }

    public Object clone() {
        Parameters clone = new Parameters();
        for (String key : this.keyToValueMap.keySet()) {
            clone.keyToValueMap.put(key, this.keyToValueMap.get(key));
        }
        for (String key : this.keyToTypeMap.keySet()) {
            clone.keyToTypeMap.put(key, (ParameterType)this.keyToTypeMap.get(key));
        }
        return clone;
    }

    public ParameterType getParameterType(String key) {
        return (ParameterType)this.keyToTypeMap.get(key);
    }

    public void setParameter(String key, Object value) {
        ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
        if (type == null) {
            LogService.logMessage("Illegal key: '" + key + "'", 4);
            type = value instanceof List ? new ParameterTypeList(key, "guessed", new ParameterTypeString(null, null)) : new ParameterTypeString(key, "guessed");
            this.keyToTypeMap.put(key, type);
        }
        this.keyToValueMap.put(key, type.checkValue(value));
    }

    public void setParameterWithoutCheck(String key, Object value) {
        if (value == null) {
            this.keyToValueMap.remove(key);
        } else {
            this.keyToValueMap.put(key, value);
        }
    }

    public Object getParameter(String key) throws UndefinedParameterError {
        if (this.keyToValueMap.containsKey(key)) {
            return this.keyToValueMap.get(key);
        }
        ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
        if (type == null) {
            return null;
        }
        Object value = type.getDefaultValue();
        if (value == null && !type.isOptional()) {
            LogService.logMessage("Parameter '" + key + "' is not set and has no default value.", 6);
            throw new UndefinedParameterError(key);
        }
        this.keyToValueMap.put(key, value);
        LogService.logMessage("Parameter '" + key + "' is not set. Using default ('" + type.toString(value) + "').", 0);
        return value;
    }

    public Set<String> getKeys() {
        return this.keyToValueMap.keySet();
    }

    public boolean equals(Object o) {
        String otherXML;
        if (!(o instanceof Parameters)) {
            return false;
        }
        String thisXML = this.getXML("");
        return thisXML.equals(otherXML = ((Parameters)o).getXML(""));
    }

    public int hashCode() {
        return this.getXML("").hashCode();
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        for (String key : this.keyToValueMap.keySet()) {
            ParameterType type;
            Object value = this.keyToValueMap.get(key);
            if (value instanceof String) {
                value = Tools.escapeXML((String)value);
            }
            if ((type = (ParameterType)this.keyToTypeMap.get(key)) != null) {
                result.append(type.getXML(indent, key, value, true));
                continue;
            }
            result.append(String.valueOf(indent) + "<parameter key=\"" + key + "\"\tvalue=\"" + value.toString() + "\"/>" + Tools.getLineSeparator());
        }
        return result.toString();
    }
}

