/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;

public class ParameterTypeInt
extends ParameterTypeNumber {
    private int defaultValue = -1;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private boolean noDefault = true;
    private boolean optional = true;

    public ParameterTypeInt(String key, String description, int min, int max) {
        this(key, description, min, max, -1);
        this.noDefault = true;
        this.optional = false;
    }

    public ParameterTypeInt(String key, String description, int min, int max, boolean optional) {
        this(key, description, min, max, -1);
        this.noDefault = true;
        this.optional = optional;
    }

    public ParameterTypeInt(String key, String description, int min, int max, int defaultValue) {
        super(key, description);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.noDefault = false;
        this.optional = true;
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }

    public int getMinValueInt() {
        return this.min;
    }

    public int getMaxValueInt() {
        return this.max;
    }

    public int getDefaultInt() {
        return this.defaultValue;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object getDefaultValue() {
        if (this.noDefault) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = (Integer)defaultValue;
    }

    public boolean isNumerical() {
        return true;
    }

    public Object checkValue(Object value) {
        String string = (String)value;
        Integer intValue = null;
        try {
            intValue = Integer.valueOf(string);
            if (intValue < this.min) {
                intValue = this.min;
                this.illegalValue(value, intValue);
            } else if (intValue > this.max) {
                intValue = this.max;
                this.illegalValue(value, intValue);
            }
        }
        catch (NumberFormatException e) {
            intValue = this.defaultValue;
            this.illegalValue(value, intValue);
        }
        return intValue;
    }

    public String getRange() {
        String range = "integer; ";
        range = this.min == Integer.MIN_VALUE ? String.valueOf(range) + "-\u221e" : String.valueOf(range) + this.min;
        range = String.valueOf(range) + "-";
        range = this.max == Integer.MAX_VALUE ? String.valueOf(range) + "+\u221e" : String.valueOf(range) + this.max;
        if (!this.noDefault) {
            range = String.valueOf(range) + "; default: " + this.getStringRepresentation(this.defaultValue);
        }
        return range;
    }

    public String getStringRepresentation(int value) {
        String valueString = String.valueOf(value);
        if (value == Integer.MAX_VALUE) {
            valueString = "+\u221e";
        } else if (value == Integer.MIN_VALUE) {
            valueString = "-\u221e";
        }
        return valueString;
    }
}

