/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;

public class ParameterTypeDouble
extends ParameterTypeNumber {
    private double defaultValue = Double.NaN;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private boolean noDefault = true;
    private boolean optional = true;

    public ParameterTypeDouble(String key, String description, double min, double max) {
        this(key, description, min, max, Double.NaN);
        this.noDefault = true;
        this.optional = false;
    }

    public ParameterTypeDouble(String key, String description, double min, double max, boolean optional) {
        this(key, description, min, max, Double.NaN);
        this.noDefault = true;
        this.optional = optional;
    }

    public ParameterTypeDouble(String key, String description, double min, double max, double defaultValue) {
        super(key, description);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.optional = true;
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object getDefaultValue() {
        if (Double.isNaN(this.defaultValue)) {
            return null;
        }
        return new Double(this.defaultValue);
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = (Double)object;
    }

    public boolean isNumerical() {
        return true;
    }

    public Object checkValue(Object value) {
        String string = (String)value;
        Double doubleValue = null;
        try {
            doubleValue = Double.valueOf(string);
            if (doubleValue < this.min) {
                doubleValue = new Double(this.min);
                this.illegalValue(value, doubleValue);
            } else if (doubleValue > this.max) {
                doubleValue = new Double(this.max);
                this.illegalValue(value, doubleValue);
            }
        }
        catch (NumberFormatException e) {
            doubleValue = new Double(this.defaultValue);
            this.illegalValue(value, doubleValue);
        }
        return doubleValue;
    }

    public String getRange() {
        String range = "real; ";
        range = this.min == Double.NEGATIVE_INFINITY ? String.valueOf(range) + "-\u221e" : String.valueOf(range) + this.min;
        range = String.valueOf(range) + "-";
        range = this.max == Double.POSITIVE_INFINITY ? String.valueOf(range) + "+\u221e" : String.valueOf(range) + this.max;
        if (!this.noDefault) {
            range = String.valueOf(range) + "; default: " + this.defaultValue;
        }
        return range;
    }
}

