/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;

public class ParameterTypeCategory
extends ParameterTypeSingle {
    private int defaultValue = 0;
    private String[] categories = new String[0];

    public ParameterTypeCategory(String key, String description, String[] categories, int defaultValue) {
        super(key, description);
        this.categories = categories;
        this.defaultValue = defaultValue;
    }

    public int getDefault() {
        return this.defaultValue;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == -1) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = (Integer)defaultValue;
    }

    public boolean isNumerical() {
        return false;
    }

    public Object checkValue(Object value) {
        String string = (String)value;
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i].equals(string)) {
                return i;
            }
            ++i;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.illegalValue(value, this.categories[this.defaultValue]);
            return this.defaultValue;
        }
    }

    public String toString(Object value) {
        return this.categories[(Integer)value];
    }

    public String[] getValues() {
        return this.categories;
    }

    public String getRange() {
        StringBuffer values = new StringBuffer();
        int i = 0;
        while (i < this.categories.length) {
            if (i > 0) {
                values.append(", ");
            }
            values.append(this.categories[i]);
            ++i;
        }
        return String.valueOf(values.toString()) + "; default: " + this.categories[this.defaultValue];
    }

    public String getCategory(int index) {
        return this.categories[index];
    }

    public int getNumberOfCategories() {
        return this.categories.length;
    }
}

