/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.Tools;

public class ParameterTypeBoolean
extends ParameterTypeSingle {
    private boolean defaultValue = false;

    public ParameterTypeBoolean(String key, String description, boolean defaultValue) {
        super(key, description);
        this.defaultValue = defaultValue;
    }

    public boolean getDefault() {
        return this.defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = (Boolean)defaultValue;
    }

    public boolean isNumerical() {
        return false;
    }

    public Object checkValue(Object value) {
        String string = ((String)value).toLowerCase().trim();
        int i = 0;
        while (i < Tools.TRUE_STRINGS.length) {
            if (Tools.TRUE_STRINGS[i].equals(string)) {
                return Boolean.TRUE;
            }
            ++i;
        }
        i = 0;
        while (i < Tools.FALSE_STRINGS.length) {
            if (Tools.FALSE_STRINGS[i].equals(string)) {
                return Boolean.FALSE;
            }
            ++i;
        }
        Boolean booleanValue = this.defaultValue;
        this.illegalValue(value, booleanValue);
        return booleanValue;
    }

    public String getRange() {
        return "boolean; default: " + this.defaultValue;
    }
}

