/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SimpleChainInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatUntilOperatorChain
extends OperatorChain {
    public static final String[] COMPARISONS = new String[]{"none", "decreasing", "non-increasing"};
    public static final int NONE = 0;
    public static final int DECREASING = 1;
    public static final int NONINCREASING = 2;
    private int iteration;
    private long stoptime;
    private double fitness;
    private IOContainer lastInput;

    public RepeatUntilOperatorChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException, MissingIOObjectException {
        IOContainer input = this.getInput();
        this.iteration = 0;
        int timeout = this.getParameterAsInt("timeout");
        this.stoptime = timeout == -1 ? Long.MAX_VALUE : System.currentTimeMillis() + 60000L * (long)timeout;
        this.lastInput = null;
        this.fitness = Double.NEGATIVE_INFINITY;
        while (!this.evaluateCondition(input)) {
            LogService.logMessage(String.valueOf(this.getName()) + ": iteration " + this.iteration, 2);
            int j = 0;
            while (j < this.getNumberOfOperators()) {
                input = this.getOperator(j).apply(input);
                ++j;
            }
            ++this.iteration;
            this.inApplyLoop();
        }
        if (this.lastInput != null) {
            input = this.lastInput;
        }
        return input.getIOObjects();
    }

    private boolean evaluateCondition(IOContainer input) throws MissingIOObjectException, UndefinedParameterError {
        double crit;
        int nrEx;
        int nrAtts;
        int maxit;
        if (this.iteration == 0 && !this.getParameterAsBoolean("condition_before")) {
            return false;
        }
        int changeType = this.getParameterAsInt("performance_change");
        if (changeType != 0) {
            if (this.iteration > 0) {
                double currentFitness = input.get(PerformanceVector.class).getMainCriterion().getFitness();
                if (changeType == 1 && currentFitness < this.fitness) {
                    return true;
                }
                if (changeType == 2 && currentFitness <= this.fitness) {
                    return true;
                }
                this.fitness = currentFitness;
            }
            this.lastInput = input.copy();
            input.remove(PerformanceVector.class);
        }
        if (this.iteration >= (maxit = this.getParameterAsInt("max_iterations"))) {
            LogService.logMessage("Maximum number of iterations met.", 2);
            return true;
        }
        if (System.currentTimeMillis() > this.stoptime) {
            LogService.logMessage("Runtime exceeded.", 2);
            return true;
        }
        int maxAtts = this.getParameterAsInt("max_attributes");
        int minAtts = this.getParameterAsInt("min_attributes");
        if (!(maxAtts >= Integer.MAX_VALUE && minAtts <= 0 || (nrAtts = input.get(ExampleSet.class).getAttributes().size()) <= maxAtts && nrAtts >= minAtts)) {
            return false;
        }
        int maxEx = this.getParameterAsInt("max_examples");
        int minEx = this.getParameterAsInt("min_examples");
        if (!(maxEx >= Integer.MAX_VALUE && minEx <= 0 || (nrEx = input.get(ExampleSet.class).size()) <= maxEx && nrEx >= minEx)) {
            return false;
        }
        double maxCrit = this.getParameterAsDouble("max_criterion");
        double minCrit = this.getParameterAsDouble("min_criterion");
        if ((maxCrit < Double.POSITIVE_INFINITY || minCrit > Double.NEGATIVE_INFINITY) && ((crit = input.get(PerformanceVector.class).getMainCriterion().getAverage()) > maxCrit || crit < minCrit)) {
            return false;
        }
        LogService.logMessage("All criteria met.", 2);
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt("min_attributes", "Minimal number of attributes in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("max_attributes", "Maximal number of attributes in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("min_examples", "Minimal number of examples in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("max_examples", "Maximal number of examples in first example set", 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("min_criterion", "Minimal main criterion in first performance vector", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("max_criterion", "Maximal main criterion in first performance vector", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("max_iterations", "Maximum number of iterations", 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeInt("timeout", "Timeout in minutes (-1 = no timeout)", 1, Integer.MAX_VALUE, -1);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeCategory("performance_change", "Stop when performance of inner chain behaves like this.", COMPARISONS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("condition_before", "Evaluate condition before inner chain is applied (true) or after?", true);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

