/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomOptimizationChain
extends OperatorChain {
    private int iteration;
    private double currentBestPerformance = Double.NaN;
    private double avgPerformance = 0.0;

    public RandomOptimizationChain(OperatorDescription description) {
        super(description);
        this.addValue(new Value("iteration", "The number of the current iteration."){

            public double getValue() {
                return RandomOptimizationChain.this.iteration;
            }
        });
        this.addValue(new Value("performance", "The current best performance"){

            public double getValue() {
                return RandomOptimizationChain.this.currentBestPerformance;
            }
        });
        this.addValue(new Value("avg_performance", "The average performance"){

            public double getValue() {
                return RandomOptimizationChain.this.avgPerformance;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numCycles = this.getParameterAsInt("iterations");
        this.iteration = 0;
        double maxValue = Double.NEGATIVE_INFINITY;
        double perfSum = 0.0;
        IOContainer bestResult = null;
        int timeout = this.getParameterAsInt("timeout");
        long stoptime = timeout == -1 ? Long.MAX_VALUE : System.currentTimeMillis() + 60000L * (long)timeout;
        int i = 0;
        while (i < numCycles) {
            IOContainer io = this.applyInnerLoop();
            PerformanceVector perf = io.remove(PerformanceVector.class);
            perfSum += perf.getMainCriterion().getAverage();
            if (perf.getMainCriterion().getFitness() > maxValue) {
                maxValue = perf.getMainCriterion().getFitness();
                bestResult = io;
            }
            this.currentBestPerformance = maxValue;
            ++this.iteration;
            this.avgPerformance = perfSum / (double)this.iteration;
            if (System.currentTimeMillis() > stoptime) {
                LogService.logMessage("Runtime exceeded in iteration " + this.iteration + ".", 2);
                break;
            }
            this.inApplyLoop();
            ++i;
        }
        return bestResult.getIOObjects();
    }

    private IOContainer applyInnerLoop() throws OperatorException {
        IOContainer container = this.getInput().copy();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            container = this.getOperator(i).apply(container);
            ++i;
        }
        return container;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("iterations", "The number of iterations to perform", 1, Integer.MAX_VALUE, false));
        types.add(new ParameterTypeInt("timeout", "Timeout in minutes (-1 = no timeout)", 1, Integer.MAX_VALUE, -1));
        return types;
    }
}

