/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParameterSet
extends ResultObjectAdapter
implements Saveable {
    private static final long serialVersionUID = -2615523039124583537L;
    private List<ParameterValue> parameterValues = new LinkedList<ParameterValue>();
    private transient PerformanceVector performance;

    private ParameterSet() {
    }

    public ParameterSet(Operator[] operators, String[] parameters, String[] values, PerformanceVector value) {
        if (operators.length != parameters.length || operators.length != values.length) {
            throw new IllegalArgumentException("The arrays operators, parameters, and values must be of equal size!");
        }
        int i = 0;
        while (i < operators.length) {
            this.parameterValues.add(new ParameterValue(operators[i].getName(), parameters[i], values[i]));
            ++i;
        }
        this.performance = value;
    }

    public String getName() {
        return "ParameterSet";
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Parameter set:" + Tools.getLineSeparator());
        str.append(String.valueOf(Tools.getLineSeparator()) + "Performance: " + this.performance + Tools.getLineSeparator());
        Iterator<ParameterValue> i = this.parameterValues.iterator();
        while (i.hasNext()) {
            str.append(String.valueOf(((Object)i.next()).toString()) + Tools.getLineSeparator());
        }
        return str.toString();
    }

    public PerformanceVector getPerformance() {
        return this.performance;
    }

    public void applyAll(Experiment experiment, Map nameMap) {
        Iterator<ParameterValue> i = this.parameterValues.iterator();
        while (i.hasNext()) {
            i.next().apply(experiment, nameMap);
        }
    }

    public void save(File file) throws IOException {
        this.writeParameterSet(new PrintWriter(new FileWriter(file)));
    }

    public String getExtension() {
        return "par";
    }

    public String getFileDescription() {
        return "parameter set file";
    }

    public void writeParameterSet(PrintWriter out) {
        out.println("<parameterset version=\"" + Yale.getVersion() + "\">");
        for (ParameterValue value : this.parameterValues) {
            out.println("    <parameter operator=\"" + value.getOperator() + "\" key=\"" + value.getParameterKey() + "\" value=\"" + value.getParameterValue() + "\"/>");
        }
        out.println("</parameterset>");
    }

    public static ParameterSet readParameterSet(InputStream in) throws IOException {
        ParameterSet parameterSet = new ParameterSet();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (SAXException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Element parametersElement = document.getDocumentElement();
        if (!parametersElement.getTagName().equals("parameterset")) {
            throw new IOException("Outer tag of parameter set file must be <parameterset>");
        }
        NodeList parameters = parametersElement.getChildNodes();
        int i = 0;
        while (i < parameters.getLength()) {
            Node node = parameters.item(i);
            if (node instanceof Element) {
                Element parameterTag = (Element)node;
                String tagName = parameterTag.getTagName();
                if (!tagName.equals("parameter")) {
                    throw new IOException("Only tags <parameter> are allowed, was " + tagName);
                }
                String operatorName = parameterTag.getAttribute("operator");
                String parameterKey = parameterTag.getAttribute("key");
                String parameterValue = parameterTag.getAttribute("value");
                parameterSet.parameterValues.add(new ParameterValue(operatorName, parameterKey, parameterValue));
            }
            ++i;
        }
        return parameterSet;
    }

    private static class ParameterValue
    implements Serializable {
        private static final long serialVersionUID = -6847818423564185071L;
        private String operator;
        private String parameterKey;
        private String parameterValue;

        private ParameterValue(String operator, String parameterKey, String parameterValue) {
            this.operator = operator;
            this.parameterKey = parameterKey;
            this.parameterValue = parameterValue;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getParameterKey() {
            return this.parameterKey;
        }

        public String getParameterValue() {
            return this.parameterValue;
        }

        public String toString() {
            return String.valueOf(this.operator) + "." + this.parameterKey + "\t= " + this.parameterValue;
        }

        public void apply(Experiment experiment, Map nameMap) {
            String opName = (String)nameMap.get(this.operator);
            if (opName == null) {
                opName = this.operator;
            }
            LogService.logMessage("Setting parameter '" + this.parameterKey + "' of operator '" + opName + "' to '" + this.parameterValue + "'.", 0);
            Operator operator = experiment.getOperator(opName);
            if (operator == null) {
                LogService.logMessage("No such operator: '" + opName + "'.", 0);
            } else {
                operator.getParameters().setParameter(this.parameterKey, this.parameterValue);
            }
        }
    }
}

