/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeParameterValue;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterOptimizationOperator
extends OperatorChain {
    public ParameterOptimizationOperator(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "currently best performance"){

            public double getValue() {
                return ParameterOptimizationOperator.this.getCurrentBestPerformance();
            }
        });
    }

    public abstract double getCurrentBestPerformance();

    protected PerformanceVector getPerformance() throws OperatorException {
        IOObject[] evalout = super.apply();
        IOContainer evalCont = new IOContainer(evalout);
        return evalCont.remove(PerformanceVector.class);
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ParameterSet.class, PerformanceVector.class};
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList("parameters", "Parameters to optimize in the format OPERATORNAME.PARAMETERNAME and either a comma separated list of parameter values or a single value.", new ParameterTypeParameterValue("value(s)", "The value(s) of the parameter (comma-separated if more than one or [start;end;step])"));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

