/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SimpleChainInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeParameterValue;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterIteration
extends OperatorChain {
    private int numberOfCombinations = 0;
    private PerformanceVector performance;
    private int iteration = 0;

    public ParameterIteration(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The last performance."){

            public double getValue() {
                if (ParameterIteration.this.performance != null) {
                    return ParameterIteration.this.performance.getMainCriterion().getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("iteration", "The current iteration."){

            public double getValue() {
                return ParameterIteration.this.iteration;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IOObject[] apply() throws OperatorException {
        input = this.getInput();
        output = new LinkedList<IOObject>();
        isSynchronized = this.getParameterAsBoolean("synchronize");
        keepOutput = this.getParameterAsBoolean("keep_output");
        parameterList = this.getParameterList("parameters");
        operators = new Operator[parameterList.size()];
        parameters = new String[parameterList.size()];
        values = new String[parameterList.size()][];
        currentIndex = new int[parameterList.size()];
        i = parameterList.iterator();
        index = 0;
        lastNumberOfValues = -1;
        this.numberOfCombinations = 1;
        while (i.hasNext()) {
            block28: {
                keyValue = (Object[])i.next();
                parameter = ((String)keyValue[0]).split("\\.");
                if (parameter.length != 2) {
                    throw new UserError((Operator)this, 907, keyValue[0]);
                }
                operator = this.getExperiment().getOperator(parameter[0]);
                if (operator == null) {
                    throw new UserError((Operator)this, 109, parameter[0]);
                }
                operators[index] = operator;
                parameters[index] = parameter[1];
                targetType = operators[index].getParameters().getParameterType(parameters[index]);
                if (targetType == null) {
                    throw new UserError((Operator)this, 906, String.valueOf(parameter[0]) + "." + parameter[1]);
                }
                if (!(targetType instanceof ParameterTypeSingle)) {
                    throw new UserError((Operator)this, 908, String.valueOf(parameter[0]) + "." + parameter[1]);
                }
                paraString = (String)keyValue[1];
                startIndex = paraString.indexOf("[");
                if (startIndex >= 0) {
                    try {
                        endIndex = paraString.indexOf("]");
                        if (endIndex > startIndex) {
                            startEndStepArray = paraString.substring(startIndex + 1, endIndex).trim().split(";");
                            if (startEndStepArray.length != 3) {
                                throw new Exception("number of entries must be 3 (start, end, and step size)");
                            }
                            startValue = Double.parseDouble(startEndStepArray[0]);
                            endValue = Double.parseDouble(startEndStepArray[1]);
                            step = Double.parseDouble(startEndStepArray[2]);
                            if (step == 0.0) {
                                throw new Exception("step size of 0 is not allowed");
                            }
                            if (endValue <= startValue + step) {
                                throw new Exception("end value must at least be as large as start value plus step size");
                            }
                            allValues = new String[(int)((endValue - startValue) / step) + 1];
                            currentValue = startValue;
                            counter = 0;
                            while (currentValue <= endValue) {
                                allValues[counter] = String.valueOf(currentValue);
                                currentValue += step;
                                ++counter;
                            }
                            values[index] = allValues;
                            break block28;
                        }
                        throw new Exception("']' was missing");
                    }
                    catch (Exception e) {
                        throw new UserError((Operator)this, 116, keyValue[0], (Object)("Parameter values must be defined as a comma separated list or by [start;end;step], was '" + keyValue[1] + "'. Error: " + e.getMessage()));
                    }
                }
                values[index] = ((String)keyValue[1]).split(",");
            }
            if (!isSynchronized) {
                this.numberOfCombinations *= values[index].length;
            } else {
                this.numberOfCombinations = values[index].length;
                if (lastNumberOfValues < 0) {
                    lastNumberOfValues = values[index].length;
                } else if (lastNumberOfValues != values[index].length) {
                    throw new UserError(this, 926);
                }
            }
            ++index;
        }
        this.iteration = 0;
        while (true) {
            block29: {
                block30: {
                    LogService.logMessage("Using parameter set", 2);
                    j = 0;
                    while (j < operators.length) {
                        operators[j].getParameters().setParameter(parameters[j], values[j][currentIndex[j]].trim());
                        LogService.logMessage(operators[j] + "." + parameters[j] + " = " + values[j][currentIndex[j]].trim(), 2);
                        ++j;
                    }
                    this.setInput(input.copy());
                    evalout = super.apply();
                    evalCont = new IOContainer(evalout);
                    try {
                        this.performance = evalCont.remove(PerformanceVector.class);
                    }
                    catch (MissingIOObjectException e) {
                        LogService.logMessage("Inner operators of ParameterIteration do not provide performance vectors: performance cannot be plotted!", 2);
                    }
                    if (keepOutput) {
                        j = 0;
                        while (j < evalout.length) {
                            output.add(evalout[j]);
                            ++j;
                        }
                    }
                    ++this.iteration;
                    ok = true;
                    if (isSynchronized) break block30;
                    k = 0;
                    if (true) ** GOTO lbl105
                    do {
                        currentIndex[k] = 0;
                        if (++k >= currentIndex.length) {
                            ok = false;
                            break block29;
                        }
lbl105:
                        // 3 sources

                        v0 = k;
                    } while ((currentIndex[v0] = currentIndex[v0] + 1) >= values[k].length);
                    break block29;
                }
                k = 0;
                while (k < currentIndex.length) {
                    v1 = k++;
                    currentIndex[v1] = currentIndex[v1] + 1;
                }
                if (currentIndex[0] >= values[0].length) {
                    ok = false;
                    break;
                }
            }
            if (!ok) break;
            this.inApplyLoop();
        }
        temp = new IOObject[output.size()];
        output.toArray(temp);
        return temp;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList("parameters", "A list of parameters to optimize", new ParameterTypeParameterValue("value", "The values of the parameter (comma-separated"));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("synchronize", "Synchronize parameter iteration", false));
        types.add(new ParameterTypeBoolean("keep_output", "Keep the output of the last operator in th operator chain", false));
        return types;
    }
}

