/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SimpleChainInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInnerOperator;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorEnabler
extends OperatorChain {
    public OperatorEnabler(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String operatorName = this.getParameterAsString("operator_name");
        Operator operator = this.getExperiment().getOperator(operatorName);
        if (operator == null) {
            throw new UserError((Operator)this, 109, operatorName);
        }
        operator.setEnabled(this.getParameterAsBoolean("enable"));
        return super.apply();
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        try {
            Operator operator;
            String operatorName = this.getParameterAsString("operator_name");
            if (operatorName != null && (operator = this.getExperiment().getOperator(operatorName)) != null) {
                operator.setEnabled(this.getParameterAsBoolean("enable"));
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public boolean getAddOnlyAdditionalOutput() {
        return true;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInnerOperator("operator_name", "The name of the operator which should be disabled or enabled"));
        types.add(new ParameterTypeBoolean("enable", "Indicates if the operator should be enabled (true) or disabled (false)", false));
        return types;
    }
}

