/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SimpleChainInnerOperatorCondition;
import java.util.Iterator;
import java.util.LinkedList;

public class MultipleLabelIterator
extends OperatorChain {
    public MultipleLabelIterator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute[] labels = this.getLabels(exampleSet);
        if (labels.length == 0) {
            throw new UserError(this, 105);
        }
        LinkedList<IOObject> outputs = new LinkedList<IOObject>();
        int i = 0;
        while (i < labels.length) {
            ExampleSet cloneSet = (ExampleSet)exampleSet.clone();
            cloneSet.getAttributes().setLabel(labels[i]);
            IOContainer input = new IOContainer(new IOObject[]{cloneSet});
            int o = 0;
            while (o < this.getNumberOfOperators()) {
                input = this.getOperator(o).apply(input);
                ++o;
            }
            IOObject[] innerResult = input.getIOObjects();
            int j = 0;
            while (j < innerResult.length) {
                outputs.add(innerResult[j]);
                ++j;
            }
            this.inApplyLoop();
            ++i;
        }
        IOObject[] result = new IOObject[outputs.size()];
        outputs.toArray(result);
        return result;
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        if (this.getNumberOfOperators() == 0) {
            return new Class[0];
        }
        return this.getOperator(this.getNumberOfOperators() - 1).getOutputClasses();
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public boolean shouldReturnInnerOutput() {
        return true;
    }

    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    private Attribute[] getLabels(ExampleSet exampleSet) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Iterator<AttributeRole> i = exampleSet.getAttributes().specialAttributes();
        while (i.hasNext()) {
            AttributeRole role = i.next();
            String name = role.getSpecialName();
            if (!name.startsWith("label")) continue;
            attributes.add(role.getAttribute());
        }
        Attribute[] result = new Attribute[attributes.size()];
        attributes.toArray(result);
        return result;
    }
}

