/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterativeWeightOptimization
extends OperatorChain {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{AttributeWeights.class, PerformanceVector.class};
    private PerformanceVector best;
    private String[] names;
    private double[] weights;
    private double currentweight;
    private double lastperf;
    private Operator operator;
    private String parameter;
    private double min_diff;
    private AttributeWeights bestweights;
    private AttributeWeights currentweights;

    public IterativeWeightOptimization(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "performance of the last evaluated weight"){

            public double getValue() {
                return IterativeWeightOptimization.this.lastperf;
            }
        });
        this.addValue(new Value("best_performance", "best performance"){

            public double getValue() {
                if (IterativeWeightOptimization.this.best != null) {
                    return IterativeWeightOptimization.this.best.getMainCriterion().getAverage();
                }
                return Double.NaN;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        ExampleSet exampleSet = (ExampleSet)input.get(ExampleSet.class).clone();
        this.currentweights = input.get(AttributeWeights.class);
        this.names = new String[exampleSet.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.names[index] = attribute.getName();
            if (Double.isNaN(this.currentweights.getWeight(this.names[index]))) {
                throw new OperatorException("The AttributeWeights don't match with the ExampleSet.");
            }
            ++index;
        }
        this.bestweights = (AttributeWeights)this.currentweights.clone();
        this.getParametersToOptimize();
        this.operator.getParameters().setParameter("weight_relation", "greater");
        this.lastperf = Double.NaN;
        this.weights = new double[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            this.weights[i] = Math.abs(this.currentweights.getWeight(this.names[i]));
            ++i;
        }
        Arrays.sort(this.weights);
        int nullindex = 0;
        this.currentweight = 0.0;
        this.best = null;
        boolean lastiteration = false;
        int iter = 0;
        int max_iter_without_improvement = this.getParameterAsInt("iterations_without_improvement");
        int iter_without_improvement = 0;
        while (true) {
            ++iter;
            int not_zero = 0;
            int i2 = 0;
            while (i2 < this.names.length) {
                if (Math.abs(this.currentweights.getWeight(this.names[i2])) > this.currentweight) {
                    ++not_zero;
                }
                ++i2;
            }
            if (this.currentweight == 0.0) {
                not_zero = this.names.length;
            }
            if (not_zero == 0) {
                LogService.logMessage("Stopped after " + iter + " iterations. No attributes left.", 2);
                break;
            }
            LogService.logMessage("Iteration: " + iter, 3);
            LogService.logMessage("Number weight not zero: " + not_zero, 3);
            this.operator.getParameters().setParameter(this.parameter, Double.toString(this.currentweight));
            LogService.logMessage(this.operator + "." + this.parameter + " = " + this.currentweight, 2);
            IOContainer container = input.copy();
            i2 = 0;
            while (i2 < this.getNumberOfOperators()) {
                container = this.getOperator(i2).apply(container);
                ++i2;
            }
            if (!container.contains(PerformanceVector.class)) {
                throw new OperatorException("Cannot find PerformanceVector!");
            }
            PerformanceVector performance = container.get(PerformanceVector.class);
            this.lastperf = performance.getMainCriterion().getFitness();
            LogService.logMessage(performance.toResultString(), 3);
            if (this.best == null || performance.compareTo(this.best) > 0) {
                this.best = performance;
                this.bestweights = (AttributeWeights)this.currentweights.clone();
                iter_without_improvement = 0;
            } else {
                ++iter_without_improvement;
            }
            if (iter_without_improvement >= max_iter_without_improvement || lastiteration) break;
            AttributeWeights evalweights = container.get(AttributeWeights.class);
            int i3 = 0;
            while (i3 < this.names.length) {
                double w = evalweights.getWeight(this.names[i3]);
                if (Double.isNaN(w)) {
                    this.currentweights.setWeight(this.names[i3], 0.0);
                } else if (this.currentweights.getWeight(this.names[i3]) != 0.0) {
                    this.currentweights.setWeight(this.names[i3], w);
                }
                ++i3;
            }
            this.weights = new double[this.names.length];
            i3 = 0;
            while (i3 < this.names.length) {
                this.weights[i3] = Math.abs(this.currentweights.getWeight(this.names[i3]));
                ++i3;
            }
            Arrays.sort(this.weights);
            nullindex = 0;
            while (this.weights[nullindex] == 0.0 && nullindex < this.names.length - 1) {
                ++nullindex;
            }
            while (Math.abs(this.weights[nullindex]) < this.min_diff && nullindex < this.names.length - 1) {
                ++nullindex;
            }
            this.currentweight = this.weights[nullindex];
            if (nullindex == this.names.length - 2) {
                lastiteration = true;
                if (this.weights[nullindex] == 0.0) break;
            }
            if (nullindex == this.names.length - 1) break;
            this.inApplyLoop();
        }
        input.remove(AttributeWeights.class);
        return new IOObject[]{this.best, this.bestweights};
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public void getParametersToOptimize() throws OperatorException {
        this.min_diff = this.getParameterAsDouble("min_diff");
        String keyvalue = this.getParameterAsString("parameter");
        String[] parameter = keyvalue.split("\\.");
        if (parameter.length < 2 || parameter.length > 3) {
            throw new UserError((Operator)this, 907, keyvalue);
        }
        this.operator = this.getExperiment().getOperator(parameter[0]);
        if (this.operator == null) {
            throw new UserError((Operator)this, 109, parameter[0]);
        }
        ParameterType targetType = this.operator.getParameters().getParameterType(parameter[1]);
        this.parameter = parameter[1];
        if (targetType == null) {
            throw new UserError((Operator)this, 906, String.valueOf(parameter[0]) + "." + parameter[1]);
        }
        if (!(targetType instanceof ParameterTypeNumber)) {
            throw new UserError((Operator)this, 909, String.valueOf(parameter[0]) + "." + parameter[1]);
        }
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class, AttributeWeights.class});
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString("parameter", "The parameter to set the weight value");
        types.add(type);
        type = new ParameterTypeDouble("min_diff", "The minimum difference between two weights.", 0.0, Double.POSITIVE_INFINITY, 1.0E-10);
        types.add(type);
        type = new ParameterTypeInt("iterations_without_improvement", "Number iterations without performance improvement.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

