/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SimpleChainInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingOperatorChain
extends OperatorChain {
    public IteratingOperatorChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int it = this.getParameterAsInt("iterations");
        int timeOut = this.getParameterAsInt("timeout");
        long stoptime = Long.MAX_VALUE;
        if (timeOut >= 0) {
            stoptime = System.currentTimeMillis() + 60000L * (long)timeOut;
        }
        IOContainer input = this.getInput();
        int i = 0;
        while (i < it) {
            int j = 0;
            while (j < this.getNumberOfOperators()) {
                input = this.getOperator(j).apply(input);
                ++j;
            }
            if (timeOut >= 0 && System.currentTimeMillis() > stoptime) break;
            this.inApplyLoop();
            ++i;
        }
        return new IOObject[0];
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("iterations", "Number of iterations", 0, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("timeout", "Timeout in minutes (-1: no timeout)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

