/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.meta.ParameterOptimizationOperator;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

public class GridSearchParameterOptimizationOperator
extends ParameterOptimizationOperator {
    protected List parameterList;
    protected Operator[] operators;
    protected String[] parameters;
    protected String[][] values;
    protected int[] currentIndex;
    protected int numberOfCombinations = 1;
    private ParameterSet best;

    public GridSearchParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    public void getParametersToOptimize() throws OperatorException {
        this.parameterList = this.getParameterList("parameters");
        this.operators = new Operator[this.parameterList.size()];
        this.parameters = new String[this.parameterList.size()];
        this.values = new String[this.parameterList.size()][];
        this.currentIndex = new int[this.parameterList.size()];
        int index = 0;
        this.numberOfCombinations = 1;
        for (Object[] keyValue : this.parameterList) {
            block12: {
                String[] parameter = ((String)keyValue[0]).split("\\.");
                if (parameter.length != 2) {
                    throw new UserError((Operator)this, 907, keyValue[0]);
                }
                Operator operator = this.getExperiment().getOperator(parameter[0]);
                if (operator == null) {
                    throw new UserError((Operator)this, 109, parameter[0]);
                }
                this.operators[index] = operator;
                this.parameters[index] = parameter[1];
                ParameterType targetType = this.operators[index].getParameters().getParameterType(this.parameters[index]);
                if (targetType == null) {
                    throw new UserError((Operator)this, 906, String.valueOf(parameter[0]) + "." + parameter[1]);
                }
                String paraString = (String)keyValue[1];
                int startIndex = paraString.indexOf("[");
                if (startIndex >= 0) {
                    try {
                        int endIndex = paraString.indexOf("]");
                        if (endIndex > startIndex) {
                            String[] startEndStepArray = paraString.substring(startIndex + 1, endIndex).trim().split(";");
                            if (startEndStepArray.length != 3) {
                                throw new Exception("number of entries must be 3 (start, end, and step size)");
                            }
                            double startValue = Double.parseDouble(startEndStepArray[0]);
                            double endValue = Double.parseDouble(startEndStepArray[1]);
                            double step = Double.parseDouble(startEndStepArray[2]);
                            if (step == 0.0) {
                                throw new Exception("step size of 0 is not allowed");
                            }
                            if (endValue <= startValue + step) {
                                throw new Exception("end value must at least be as large as start value plus step size");
                            }
                            String[] allValues = new String[(int)((endValue - startValue) / step) + 1];
                            double currentValue = startValue;
                            int counter = 0;
                            while (currentValue <= endValue) {
                                allValues[counter] = String.valueOf(currentValue);
                                currentValue += step;
                                ++counter;
                            }
                            this.values[index] = allValues;
                            break block12;
                        }
                        throw new Exception("']' was missing");
                    }
                    catch (Throwable e) {
                        throw new UserError((Operator)this, 116, keyValue[0], (Object)("Parameter values must be defined as a comma separated list or by [start;end;step], was '" + keyValue[1] + "'. Error: " + e.getMessage()));
                    }
                }
                this.values[index] = ((String)keyValue[1]).split(",");
            }
            this.numberOfCombinations *= this.values[index].length;
            ++index;
        }
    }

    public double getCurrentBestPerformance() {
        if (this.best != null) {
            return this.best.getPerformance().getMainCriterion().getAverage();
        }
        return Double.NaN;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        this.getParametersToOptimize();
        LogService.logMessage(String.valueOf(this.getName()) + ": total number of combinations is " + this.numberOfCombinations, 2);
        if (this.numberOfCombinations <= 1) {
            throw new UserError(this, 922);
        }
        int counter = 1;
        this.best = null;
        while (true) {
            boolean ok;
            block10: {
                int n;
                int k;
                block9: {
                    LogService.logMessage("Using parameter set " + counter + " / " + this.numberOfCombinations + ": ", 2);
                    int j = 0;
                    while (j < this.operators.length) {
                        this.operators[j].getParameters().setParameter(this.parameters[j], this.values[j][this.currentIndex[j]]);
                        LogService.logMessage(this.operators[j] + "." + this.parameters[j] + " = " + this.values[j][this.currentIndex[j]], 2);
                        ++j;
                    }
                    this.setInput(input.copy());
                    PerformanceVector performance = this.getPerformance();
                    if (this.best == null || performance.compareTo(this.best.getPerformance()) > 0) {
                        String[] bestValues = new String[this.parameters.length];
                        int j2 = 0;
                        while (j2 < this.parameters.length) {
                            bestValues[j2] = this.values[j2][this.currentIndex[j2]];
                            ++j2;
                        }
                        this.best = new ParameterSet(this.operators, this.parameters, bestValues, performance);
                    }
                    k = 0;
                    ok = true;
                    if (!true) break block9;
                    n = k;
                    if ((this.currentIndex[n] = this.currentIndex[n] + 1) < this.values[k].length) break block10;
                }
                do {
                    this.currentIndex[k] = 0;
                    if (++k >= this.currentIndex.length) {
                        ok = false;
                        break;
                    }
                    n = k;
                } while ((this.currentIndex[n] = this.currentIndex[n] + 1) >= this.values[k].length);
            }
            if (!ok) {
                return new IOObject[]{this.best, this.best.getPerformance()};
            }
            this.inApplyLoop();
            ++counter;
        }
    }
}

