/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.XMLException;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentEmbeddingOperator
extends Operator {
    public ExperimentEmbeddingOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File experimentFile = this.getParameterAsFile("experiment_file");
        Experiment experiment = null;
        try {
            experiment = new Experiment(experimentFile);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, experimentFile, (Object)e.getMessage());
        }
        catch (XMLException e) {
            throw new UserError((Operator)this, 401, e.getMessage());
        }
        IOContainer result = null;
        result = this.getParameterAsBoolean("use_input") ? experiment.run(this.getInput()) : experiment.run();
        return result.getIOObjects();
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("experiment_file", "The experiment file which should be encapsulated by this operator", "xml", false));
        types.add(new ParameterTypeBoolean("use_input", "Indicates if the operator input should be used as input of the experiment", false));
        return types;
    }
}

