/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.meta.ESParameterOptimization;
import edu.udo.cs.yale.operator.meta.ParameterOptimizationOperator;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.math.optimization.ec.es.ESOptimization;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Individual;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionaryParameterOptimizationOperator
extends ParameterOptimizationOperator {
    private IOContainer input;
    private ESOptimization optimizer;
    private Operator[] operators;
    private String[] parameters;
    private int[] types;

    public EvolutionaryParameterOptimizationOperator(OperatorDescription description) {
        super(description);
        this.addValue(new Value("best", "best performance ever"){

            public double getValue() {
                return EvolutionaryParameterOptimizationOperator.this.optimizer.getBestFitnessEver();
            }
        });
    }

    @Override
    public double getCurrentBestPerformance() {
        return this.optimizer.getBestFitnessInGeneration();
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.input = this.getInput();
        List parameterList = this.getParameterList("parameters");
        this.operators = new Operator[parameterList.size()];
        this.parameters = new String[parameterList.size()];
        double[] min = new double[parameterList.size()];
        double[] max = new double[parameterList.size()];
        this.types = new int[parameterList.size()];
        int index = 0;
        for (Object[] keyValue : parameterList) {
            String[] parameter = ((String)keyValue[0]).split("\\.");
            if (parameter.length != 2) {
                throw new UserError((Operator)this, 907, keyValue[0]);
            }
            Operator operator = this.getExperiment().getOperator(parameter[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, parameter[0]);
            }
            this.operators[index] = operator;
            this.parameters[index] = parameter[1];
            ParameterType targetType = this.operators[index].getParameters().getParameterType(this.parameters[index]);
            if (targetType == null) {
                throw new UserError((Operator)this, 906, String.valueOf(parameter[0]) + "." + parameter[1]);
            }
            if (targetType instanceof ParameterTypeDouble) {
                this.types[index] = 0;
                LogService.logMessage("Parameter type of parameter " + this.parameters[index] + ": double", 2);
            } else if (targetType instanceof ParameterTypeInt) {
                this.types[index] = 1;
                LogService.logMessage("Parameter type of parameter " + this.parameters[index] + ": int", 2);
            } else {
                throw new UserError((Operator)this, 909, targetType.getKey());
            }
            String[] bounds = ((String)keyValue[1]).split(":");
            if (bounds.length != 2) {
                throw new UserError((Operator)this, 116, operator + "." + parameter[1], (Object)"Value must be colon separated pair describing the minimal and the maximal values for this parameter, e.g. 10:100");
            }
            min[index] = Double.parseDouble(bounds[0]);
            max[index] = Double.parseDouble(bounds[1]);
            ++index;
        }
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        this.optimizer = new ESParameterOptimization(this, this.operators.length, 0, this.getParameterAsInt("max_generations"), this.getParameterAsInt("generations_without_improval"), this.getParameterAsInt("population_size"), this.getParameterAsInt("selection_type"), this.getParameterAsDouble("tournament_fraction"), this.getParameterAsBoolean("keep_best"), this.getParameterAsInt("mutation_type"), this.getParameterAsDouble("crossover_prob"), this.getParameterAsBoolean("show_convergence_plot"), random);
        int i = 0;
        while (i < min.length) {
            this.optimizer.setMin(i, min[i]);
            this.optimizer.setMax(i, max[i]);
            this.optimizer.setValueType(i, this.types[i]);
            ++i;
        }
        this.optimizer.optimize();
        double[] bestParameters = this.optimizer.getBestValuesEver();
        String[] bestValues = new String[bestParameters.length];
        int i2 = 0;
        while (i2 < bestParameters.length) {
            bestValues[i2] = this.types[i2] == 0 ? String.valueOf(bestParameters[i2]) : String.valueOf((int)Math.round(bestParameters[i2]));
            ++i2;
        }
        ParameterSet bestSet = new ParameterSet(this.operators, this.parameters, bestValues, this.optimizer.getBestPerformanceEver());
        return new IOObject[]{bestSet, bestSet.getPerformance()};
    }

    public PerformanceVector setParametersAndEvaluate(Individual individual) throws OperatorException {
        double[] currentValues = individual.getValues();
        int j = 0;
        while (j < currentValues.length) {
            String value = this.types[j] == 0 ? String.valueOf(currentValues[j]) : String.valueOf((int)Math.round(currentValues[j]));
            this.operators[j].getParameters().setParameter(this.parameters[j], value);
            LogService.logMessage(this.operators[j] + "." + this.parameters[j] + " = " + value, 2);
            ++j;
        }
        this.setInput(this.input.copy());
        return this.getPerformance();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("max_generations", "Stop after this many evaluations", 1, Integer.MAX_VALUE, 50));
        types.add(new ParameterTypeInt("generations_without_improval", "Stop after this number of generations without improvement (-1: optimize until max_iterations).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt("population_size", "The population size (-1: number of examples)", -1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble("tournament_fraction", "The fraction of the population used for tournament selection.", 0.0, Double.POSITIVE_INFINITY, 0.25));
        types.add(new ParameterTypeBoolean("keep_best", "Indicates if the best individual should survive (elititst selection).", true));
        types.add(new ParameterTypeCategory("mutation_type", "The type of the mutation operator.", ESOptimization.MUTATION_TYPES, 1));
        types.add(new ParameterTypeCategory("selection_type", "The type of the selection operator.", ESOptimization.SELECTION_TYPES, 6));
        types.add(new ParameterTypeDouble("crossover_prob", "The probability for crossover.", 0.0, 1.0, 0.9));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeBoolean("show_convergence_plot", "Indicates if a dialog with a convergence plot should be drawn.", false));
        return types;
    }
}

