/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.weka;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.WekaTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeDisplayEvent;
import weka.gui.treevisualizer.TreeDisplayListener;
import weka.gui.treevisualizer.TreeVisualizer;

public class WekaClassifier
extends PredictionModel {
    private Classifier classifier;
    private String name;

    public WekaClassifier() {
    }

    public WekaClassifier(Attribute label) {
        super(label);
    }

    public WekaClassifier(String name, Attribute label, Classifier classifier) {
        super(label);
        this.name = name;
        this.classifier = classifier;
    }

    public boolean isUpdatable() {
        return this.classifier instanceof UpdateableClassifier;
    }

    public void updateModel(ExampleSet updateExampleSet) throws OperatorException {
        if (!(this.classifier instanceof UpdateableClassifier)) {
            throw new UserError(null, 135, String.valueOf(this.getClass().getName()) + " (" + this.classifier.getClass() + ")");
        }
        UpdateableClassifier updateableClassifier = (UpdateableClassifier)this.classifier;
        this.updateClassifier(updateableClassifier, updateExampleSet);
    }

    private void updateClassifier(UpdateableClassifier classifier, ExampleSet exampleSet) throws OperatorException {
        LogService.logMessage("Update Weka classifier.", 2);
        LogService.logMessage("Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "UpdateInstances", 0);
        LogService.logMessage("Actually updating Weka classifier.", 0);
        try {
            int i = 0;
            while (i < instances.numInstances()) {
                Instance instance = instances.instance(i++);
                classifier.updateClassifier(instance);
                ++i;
            }
        }
        catch (Exception e) {
            throw new OperatorException("Cannot update Weka model: " + e.getMessage());
        }
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        LogService.logMessage("Applying Weka classifier.", 2);
        LogService.logMessage("Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "ApplierInstances", 1);
        LogService.logMessage("Actually applying Weka classifier.", 0);
        int i = 0;
        for (Example e : exampleSet) {
            Instance instance = instances.instance(i++);
            this.applyModelForInstance(instance, e, predictedLabel);
        }
    }

    public void applyModelForInstance(Instance instance, Example e, Attribute predictedLabelAttribute) {
        double predictedLabel = Double.NaN;
        try {
            double wekaPrediction = this.classifier.classifyInstance(instance);
            if (predictedLabelAttribute.isNominal()) {
                double[] confidences = this.classifier.distributionForInstance(instance);
                int i = 0;
                while (i < confidences.length) {
                    String classification = instance.classAttribute().value(i);
                    e.setConfidence(classification, confidences[i]);
                    ++i;
                }
                String classification = instance.classAttribute().value((int)wekaPrediction);
                predictedLabel = predictedLabelAttribute.getMapping().mapString(classification);
            } else {
                predictedLabel = this.classifier.classifyInstance(instance);
            }
        }
        catch (Exception exc) {
            LogService.logMessage("Exception occured while classifying example:" + exc.getMessage() + " [" + exc.getClass() + "]", 6);
            exc.printStackTrace();
        }
        e.setValue(predictedLabelAttribute, predictedLabel);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " (model for label " + this.getLabel() + ")" + Tools.getLineSeparator() + this.classifier.toString();
    }

    public String toResultString() {
        return this.classifier.toString();
    }

    private Component createTextAndGraphView(final Component textView, final Component graphView) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        final JRadioButton graphViewButton = new JRadioButton("graph view", true);
        graphViewButton.setToolTipText("Changes to a graphical view of this model.");
        graphViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (graphViewButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add(graphView, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton textViewButton = new JRadioButton("text view", true);
        textViewButton.setToolTipText("Changes to a textual view of this model.");
        textViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (textViewButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add(textView, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(graphViewButton);
        group.add(textViewButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(graphViewButton);
        togglePanel.add(textViewButton);
        mainPanel.add((Component)togglePanel, "North");
        mainPanel.add(graphView, "Center");
        return mainPanel;
    }

    public Component getVisualizationComponent(IOContainer container) {
        if (this.classifier instanceof Drawable) {
            try {
                Drawable drawable = (Drawable)this.classifier;
                int graphType = drawable.graphType();
                switch (graphType) {
                    case 1: {
                        TreeVisualizer treeView = new TreeVisualizer(new TreeDisplayListener(){

                            public void userCommand(TreeDisplayEvent e) {
                            }
                        }, drawable.graph(), (NodePlace)new PlaceNode2());
                        return this.createTextAndGraphView(super.getVisualizationComponent(container), (Component)treeView);
                    }
                    case 2: {
                        GraphVisualizer visualizer = new GraphVisualizer();
                        visualizer.readBIF(drawable.graph());
                        visualizer.layoutGraph();
                        return this.createTextAndGraphView(super.getVisualizationComponent(container), (Component)visualizer);
                    }
                }
                return super.getVisualizationComponent(container);
            }
            catch (Exception e) {
                return super.getVisualizationComponent(container);
            }
        }
        return super.getVisualizationComponent(container);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        WekaClassifier other = (WekaClassifier)o;
        return other.classifier.equals(this.classifier);
    }

    public int hashCode() {
        return this.classifier.hashCode();
    }
}

