/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.weka;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.weka.WekaClassifier;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaLearnerCapabilities;
import edu.udo.cs.yale.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaLearner
extends AbstractLearner
implements TechnicalInformationHandler {
    public static final String[] WEKA_CLASSIFIERS = WekaTools.getWekaClasses(Classifier.class, ".meta.", false);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Classifier classifier = this.getWekaClassifier(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        LogService.logMessage(String.valueOf(this.getName()) + ": Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "LearningInstances", 0);
        try {
            LogService.logMessage(String.valueOf(this.getName()) + ": Building Weka classifier.", 0);
            classifier.buildClassifier(instances);
        }
        catch (UnassignedClassException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, new Object[]{this.getOperatorClassName(), e});
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, new Object[]{this.getOperatorClassName(), e});
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{this.getOperatorClassName(), e.getMessage()});
        }
        return new WekaClassifier(this.getOperatorClassName(), exampleSet.getAttributes().getLabel(), classifier);
    }

    private Classifier getWekaClassifier(String[] parameters) throws OperatorException {
        String classifierName = this.getWekaClassPath();
        Classifier classifier = null;
        try {
            classifier = Classifier.forName((String)classifierName, (String[])parameters);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{classifierName, e});
        }
        return classifier;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            Classifier classifier = this.getWekaClassifier(null);
            if (classifier instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)classifier).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    public String getWekaClassPath() {
        int i = 0;
        while (i < WEKA_CLASSIFIERS.length) {
            if (WEKA_CLASSIFIERS[i].endsWith(this.getOperatorClassName())) {
                return WEKA_CLASSIFIERS[i];
            }
            ++i;
        }
        return null;
    }

    public List getWekaParameterList() {
        return this.wekaParameters;
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        Classifier classifier;
        try {
            classifier = this.getWekaClassifier(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        }
        catch (OperatorException e) {
            return false;
        }
        return WekaLearnerCapabilities.supportsCapability(classifier, capability);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Classifier classifier = null;
        try {
            classifier = this.getWekaClassifier(null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka classifier " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (classifier != null) {
            WekaTools.addParameterTypes((OptionHandler)classifier, types, this.wekaParameters, false, null);
        }
        return types;
    }
}

