/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.weka;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.condition.AllInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.learner.Learner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.weka.GenericWekaLearner;
import edu.udo.cs.yale.operator.learner.weka.WekaClassifier;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaLearnerCapabilities;
import edu.udo.cs.yale.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaEnsembleLearner
extends OperatorChain
implements Learner,
TechnicalInformationHandler {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{Model.class};
    public static final String[] WEKA_CLASSIFIERS = WekaTools.getWekaClasses(Classifier.class, ".meta.", true);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaEnsembleLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Model model = this.learn(exampleSet);
        return new IOObject[]{model};
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        String[] wekaParas = this.getWekaParameters();
        if (wekaParas == null) {
            throw new UserError((Operator)this, 131, "simple Weka learner");
        }
        Classifier classifier = this.getWekaClassifier(wekaParas);
        LogService.logMessage(String.valueOf(this.getName()) + ": Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "MetaLearningInstances", 0);
        try {
            LogService.logMessage(String.valueOf(this.getName()) + ": Building Weka classifier.", 0);
            classifier.buildClassifier(instances);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{this.getOperatorClassName(), e});
        }
        return new WekaClassifier(this.getOperatorClassName(), exampleSet.getAttributes().getLabel(), classifier);
    }

    public String getWekaClassPath() {
        int i = 0;
        while (i < WEKA_CLASSIFIERS.length) {
            if (WEKA_CLASSIFIERS[i].endsWith(this.getOperatorClassName())) {
                return WEKA_CLASSIFIERS[i];
            }
            ++i;
        }
        return null;
    }

    public List getWekaParameterList() {
        return this.wekaParameters;
    }

    private Classifier getWekaClassifier(String[] parameters) throws OperatorException {
        String classifierName = this.getWekaClassPath();
        Classifier classifier = null;
        try {
            classifier = Classifier.forName((String)classifierName, (String[])parameters);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{classifierName, e});
        }
        return classifier;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            Classifier classifier = this.getWekaClassifier(null);
            if (classifier instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)classifier).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    private String[] getWekaParameters() throws OperatorException {
        String[] ensebleParameters = WekaTools.getWekaParametersFromTypes(this, this.wekaParameters);
        LinkedList<String> allParameters = new LinkedList<String>();
        String[] stringArray = ensebleParameters;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String p = stringArray[n];
            allParameters.add(p);
            ++n;
        }
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            String innerLearnerString;
            Operator operator = this.getOperator(i);
            if (operator instanceof GenericWekaLearner) {
                allParameters.add("-B");
                GenericWekaLearner inner = (GenericWekaLearner)operator;
                innerLearnerString = inner.getWekaClassPath();
                String[] innerParameters = WekaTools.getWekaParametersFromTypes(inner, inner.getWekaParameterList());
                int p = 0;
                while (p < innerParameters.length) {
                    innerLearnerString = String.valueOf(innerLearnerString) + " " + innerParameters[p];
                    ++p;
                }
            } else {
                throw new UserError((Operator)this, 127, "Inner operator of a Weka ensemble learning operator '" + this.getName() + "' must be another Weka learning scheme.");
            }
            allParameters.add(innerLearnerString);
            ++i;
        }
        String[] result = new String[allParameters.size()];
        allParameters.toArray(result);
        return result;
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        try {
            Classifier classifier = this.getWekaClassifier(this.getWekaParameters());
            return WekaLearnerCapabilities.supportsCapability(classifier, capability);
        }
        catch (OperatorException e) {
            return false;
        }
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return false;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return false;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), (Object)"estimation of performance not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), (Object)"calculation of weights not supported.");
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class});
    }

    @Override
    public void performAdditionalChecks() throws UserError {
        super.performAdditionalChecks();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            if (!(this.getOperator(i) instanceof GenericWekaLearner)) {
                throw new UserError((Operator)this, 127, "Inner operator of a Weka ensemble learning operator '" + this.getName() + "' must be another Weka learning scheme.");
            }
            ++i;
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Classifier classifier = null;
        try {
            classifier = this.getWekaClassifier(null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka classifier " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (classifier != null) {
            WekaTools.addParameterTypes((OptionHandler)classifier, types, this.wekaParameters, true, "B");
        }
        return types;
    }
}

