/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNodePainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JPanel;

public class TreePainter
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected boolean resized = false;
    protected transient TreeNode root;
    protected transient TreeNodePainter painter;
    protected ArrayList<LinkedList<TreeNode>> levels;
    protected Map<TreeNode, Integer> shifts;
    protected Map<TreeNode, TreeNode> fathers;
    protected static final int WINDOW_BORDER = 10;
    protected static final int NODE_X_SPACE_SIBLINGS = 20;
    protected static final int NODE_X_SPACE = 20;
    protected static final int NODE_Y_SPACE = 60;
    protected int maxShift = 0;
    protected int maxTreeDepth = 0;
    protected int maxNodeWidth = 0;
    protected int maxNodeHeight = 0;
    protected int preferredWidth = 10;
    protected int preferredHeight = 10;

    public TreePainter(TreeNode root, TreeNodePainter painter) {
        this.root = root;
        this.painter = painter;
        this.shifts = new LinkedHashMap<TreeNode, Integer>();
        this.levels = new ArrayList(10);
        this.fathers = new LinkedHashMap<TreeNode, TreeNode>();
    }

    public void paintComponent(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.addRenderingHints(renderHints);
        if (this.levels.size() == 0) {
            this.storeChildren(graphics, this.root, 0);
            this.arrangeChildren();
            this.preferredWidth = this.maxShift + this.maxNodeWidth + 40;
            this.preferredHeight = (this.maxTreeDepth + 1) * (this.maxNodeHeight + 60);
        }
        graphics.translate(10, 10);
        this.paintOrderedTree(graphics);
        if (!this.resized) {
            this.invalidate();
            this.validate();
            this.resized = true;
        }
    }

    private void paintOrderedTree(Graphics2D graphics) {
        Graphics2D nodeGraphicContext = (Graphics2D)graphics.create();
        int shiftY = 0;
        int shiftX = 0;
        int i = 0;
        while (i < this.levels.size()) {
            Iterator iterator = this.levels.get(i).iterator();
            shiftY = i * (this.maxNodeHeight + 60);
            while (iterator.hasNext()) {
                TreeNode currentNode = (TreeNode)iterator.next();
                shiftX = this.shifts.get(currentNode);
                nodeGraphicContext = (Graphics2D)graphics.create();
                nodeGraphicContext.translate(shiftX, shiftY);
                this.painter.paintNode(currentNode, nodeGraphicContext, this.maxNodeWidth, this.maxNodeHeight);
                if (!this.fathers.containsKey(currentNode)) continue;
                TreeNode currentFather = this.fathers.get(currentNode);
                graphics.draw(new Line2D.Double((double)shiftX + (double)this.maxNodeWidth / 2.0, shiftY, (double)this.shifts.get(currentFather).intValue() + (double)this.maxNodeWidth / 2.0, shiftY - 60));
            }
            ++i;
        }
    }

    private void storeChildren(Graphics2D graphics, TreeNode node, int depth) {
        this.maxNodeWidth = Math.max(this.painter.getMinWidth(node, graphics), this.maxNodeWidth);
        this.maxNodeHeight = Math.max(this.painter.getMinHeight(node, graphics), this.maxNodeHeight);
        this.maxTreeDepth = Math.max(depth, this.maxTreeDepth);
        if (this.levels.size() - 1 < depth) {
            this.levels.add(new LinkedList());
        }
        this.levels.get(depth).add(node);
        if (node.hasChildren()) {
            Iterator<TreeNode> iterator = node.childIterator();
            while (iterator.hasNext()) {
                TreeNode currentChild = iterator.next();
                this.fathers.put(currentChild, node);
                this.storeChildren(graphics, currentChild, depth + 1);
            }
        }
    }

    private void arrangeChildren() {
        Iterator iterator;
        int i = 0;
        while (i < this.levels.size()) {
            iterator = this.levels.get(i).iterator();
            int shift = 0;
            TreeNode currentFather = null;
            while (iterator.hasNext()) {
                TreeNode currentNode = (TreeNode)iterator.next();
                if (this.fathers.containsKey(currentNode) && this.fathers.get(currentNode) != currentFather) {
                    shift += 20;
                    currentFather = this.fathers.get(currentNode);
                }
                this.shifts.put(currentNode, shift);
                shift += this.maxNodeWidth + 20;
            }
            ++i;
        }
        int currentLevel = this.levels.size() - 1;
        while (currentLevel >= 0) {
            iterator = this.levels.get(currentLevel).iterator();
            TreeNode currentFather = null;
            TreeNode firstChild = null;
            int currentStart = 0;
            int currentEnd = 0;
            while (iterator.hasNext()) {
                int fathersOldShift;
                int fathersNewShift;
                TreeNode currentNode = (TreeNode)iterator.next();
                if (firstChild == null) {
                    firstChild = currentNode;
                    currentFather = this.fathers.get(currentNode);
                    currentStart = this.shifts.get(currentNode);
                    continue;
                }
                if (currentFather != this.fathers.get(currentNode)) {
                    fathersNewShift = (currentStart + currentEnd) / 2;
                    fathersOldShift = this.shifts.get(currentFather);
                    if (fathersOldShift < fathersNewShift) {
                        this.shiftLevelRight(currentLevel - 1, currentFather, fathersNewShift - fathersOldShift);
                    } else if (fathersOldShift > fathersNewShift) {
                        this.shiftTreeRight(currentLevel, firstChild, fathersOldShift - fathersNewShift);
                    }
                    firstChild = currentNode;
                    currentStart = this.shifts.get(currentNode);
                    currentFather = this.fathers.get(currentNode);
                    continue;
                }
                currentEnd = this.shifts.get(currentNode);
                if (iterator.hasNext()) continue;
                fathersNewShift = (currentStart + currentEnd) / 2;
                fathersOldShift = this.shifts.get(currentFather);
                if (fathersOldShift < fathersNewShift) {
                    this.shiftLevelRight(currentLevel - 1, currentFather, fathersNewShift - fathersOldShift);
                    continue;
                }
                if (fathersOldShift <= fathersNewShift) continue;
                this.shiftTreeRight(currentLevel, firstChild, fathersOldShift - fathersNewShift);
            }
            --currentLevel;
        }
    }

    private void shiftTreeRight(int level, TreeNode startNode, int ammount) {
        ListIterator<TreeNode> iterator = this.levels.get(level).listIterator(this.levels.get(level).indexOf(startNode));
        TreeNode firstNode = null;
        while (iterator.hasNext()) {
            TreeNode currentNode = iterator.next();
            int newShift = this.shifts.get(currentNode) + ammount;
            this.shifts.put(currentNode, newShift);
            this.maxShift = Math.max(this.maxShift, newShift);
            if (firstNode != null || !currentNode.hasChildren()) continue;
            firstNode = currentNode;
        }
        if (firstNode != null && firstNode.hasChildren()) {
            this.shiftTreeRight(level + 1, firstNode.childIterator().next(), ammount);
        }
    }

    private void shiftLevelRight(int level, TreeNode startNode, int ammount) {
        TreeNode currentNode;
        ListIterator<TreeNode> iterator = this.levels.get(level).listIterator(this.levels.get(level).indexOf(startNode));
        TreeNode startFather = this.fathers.get(startNode);
        while (iterator.hasPrevious()) {
            currentNode = iterator.previous();
            if (!currentNode.hasChildren() && this.fathers.get(currentNode) == startFather) continue;
            iterator.next();
            break;
        }
        while (iterator.hasNext()) {
            currentNode = iterator.next();
            int newShift = this.shifts.get(currentNode) + ammount;
            this.shifts.put(currentNode, newShift);
            this.maxShift = Math.max(this.maxShift, newShift);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }
}

