/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.SimplePredictionModel;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AdditionalInformation;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.ClassNumberInformation;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.SimpleTreeNodePainter;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreePainter;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JScrollPane;

public class TreeModel
extends SimplePredictionModel {
    private TreeNode root;
    private Attribute labelAttribute;

    public TreeModel(Attribute labelAttribute, TreeNode root) {
        super(labelAttribute);
        this.root = root;
        this.labelAttribute = labelAttribute;
    }

    public double predict(Example example) throws OperatorException {
        return this.predict(example, this.root);
    }

    private double predict(Example example, TreeNode node) {
        Iterator<TreeNode> childIterator = node.childIterator();
        while (childIterator.hasNext()) {
            TreeNode currentChild = childIterator.next();
            if (!currentChild.getNodeCondition().testExample(example)) continue;
            return this.predict(example, currentChild);
        }
        for (AdditionalInformation info : node.getAdditionalGraphics()) {
            int i;
            if (!(info instanceof ClassNumberInformation)) continue;
            int[] classFrequencies = ((ClassNumberInformation)info).getClassFrequencies();
            int sum = 0;
            int[] nArray = classFrequencies;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                i = nArray[n];
                sum += i;
                ++n;
            }
            i = 0;
            while (i < classFrequencies.length) {
                example.setConfidence(this.labelAttribute.getMapping().mapIndex(i), (double)classFrequencies[i] / (double)sum);
                ++i;
            }
        }
        return node.getLabel();
    }

    public Component getVisualizationComponent(IOContainer container) {
        return new JScrollPane(new TreePainter(this.root, new SimpleTreeNodePainter()));
    }

    public String toString() {
        return this.toString(this.root, "|   ", new StringBuffer()).toString();
    }

    private StringBuffer toString(TreeNode node, String indent, StringBuffer buffer) {
        buffer.append(node.getNodeCondition().toString());
        if (node.hasChildren()) {
            Iterator<TreeNode> childIterator = node.childIterator();
            while (childIterator.hasNext()) {
                buffer.append("\n");
                buffer.append(indent);
                TreeNode childNode = childIterator.next();
                this.toString(childNode, String.valueOf(indent) + "|   ", buffer);
            }
        } else {
            buffer.append(": ");
            buffer.append(node.getStringLabel());
            for (AdditionalInformation a : node.getAdditionalGraphics()) {
                buffer.append("   ");
                buffer.append(a.toString());
            }
        }
        return buffer;
    }

    public void initWriting() {
        this.deleteTrainExampleSets(this.root);
    }

    private void deleteTrainExampleSets(TreeNode node) {
        Iterator<TreeNode> iterator = node.childIterator();
        while (iterator.hasNext()) {
            this.deleteTrainExampleSets(iterator.next());
        }
        node.removeTrainExampleSet();
    }
}

