/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AdditionalInformation;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNodePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTreeNodePainter
implements TreeNodePainter {
    private static final Font NODE_FONT = new Font("LucidaSans", 1, 11);
    private static final Font CONDITION_FONT = new Font("LucidaSans", 0, 9);
    private static final int TEXT_MARGIN = 4;
    private static final int FRAME_STROKE_WIDTH = 1;
    private static final int FRAME_STROKE_JOIN = 0;
    private static final int FRAME_STROKE_CAP = 0;
    private static final float FRAME_MITER_LIMIT = 3.0f;
    private static final Stroke stroke = new BasicStroke(1.0f, 0, 0, 3.0f);
    private static final Color conditionColor = SwingTools.LIGHTEST_YELLOW;
    private static final Color leafColor = SwingTools.LIGHT_BLUE;
    private static final Color leafLabelColor = SwingTools.LIGHTEST_BLUE;
    private static final Color conditionBorderColor = SwingTools.DARK_YELLOW;
    private static final Color leafBorderColor = SwingTools.DARK_BLUE;
    private static final Color leafLabelBorderColor = SwingTools.DARK_BLUE;

    @Override
    public int getMinHeight(TreeNode node, Graphics2D graphics) {
        String nodeCondition = node.getNodeCondition().toString();
        String label = node.getStringLabel();
        Rectangle2D conditionRect = CONDITION_FONT.getStringBounds(nodeCondition, graphics.getFontRenderContext());
        if (label != null) {
            Rectangle2D labelRect = NODE_FONT.getStringBounds(label, graphics.getFontRenderContext());
            double labelRectHeight = labelRect.getHeight() + 8.0;
            return (int)conditionRect.getHeight() + 8 + (int)labelRectHeight;
        }
        return (int)conditionRect.getHeight() + 8;
    }

    @Override
    public int getMinWidth(TreeNode node, Graphics2D graphics) {
        Collection<AdditionalInformation> additionals = node.getAdditionalGraphics();
        Iterator<AdditionalInformation> iterator = additionals.iterator();
        int additionalWidth = 0;
        while (iterator.hasNext()) {
            additionalWidth += iterator.next().getMinHeight(graphics);
        }
        String nodeCondition = node.getNodeCondition().toString();
        String label = node.getStringLabel();
        Rectangle2D conditionRect = CONDITION_FONT.getStringBounds(nodeCondition, graphics.getFontRenderContext());
        if (label != null) {
            Rectangle2D labelRect = NODE_FONT.getStringBounds(label, graphics.getFontRenderContext());
            double labelRectWidth = labelRect.getWidth() + 8.0;
            double condRectWidth = conditionRect.getWidth() + 8.0;
            return (int)Math.max((double)additionalWidth, Math.max(condRectWidth, labelRectWidth));
        }
        return (int)Math.max((double)additionalWidth, conditionRect.getWidth() + 8.0 + 2.0);
    }

    @Override
    public void paintNode(TreeNode node, Graphics2D graphics, int width, int height) {
        String nodeCondition = node.getNodeCondition().toString();
        String label = node.getStringLabel();
        graphics.setStroke(stroke);
        Rectangle2D conditionRect = CONDITION_FONT.getStringBounds(nodeCondition, graphics.getFontRenderContext());
        double fontHeight = conditionRect.getHeight();
        if (label != null) {
            Rectangle2D labelRect = NODE_FONT.getStringBounds(label, graphics.getFontRenderContext());
            double labelRectWidth = labelRect.getWidth() + 8.0;
            double labelRectHeight = labelRect.getHeight() + 8.0;
            double condRectWidth = Math.max(conditionRect.getWidth() + 8.0, (double)width);
            double condRectHeight = Math.max(conditionRect.getHeight() + 8.0, (double)height - labelRectHeight);
            labelRectWidth = condRectWidth = Math.max(condRectWidth, labelRectWidth);
            conditionRect.setFrame(0.0, 0.0, condRectWidth, condRectHeight);
            labelRect.setFrame(0.0, condRectHeight, labelRectWidth, labelRectHeight);
            graphics.setColor(leafColor);
            graphics.fill(conditionRect);
            graphics.setColor(leafLabelColor);
            graphics.fill(labelRect);
            graphics.setColor(leafBorderColor);
            graphics.draw(conditionRect);
            graphics.setColor(leafLabelBorderColor);
            graphics.draw(labelRect);
            graphics.setColor(Color.BLACK);
            graphics.setFont(CONDITION_FONT);
            graphics.drawString(nodeCondition, 4, (int)fontHeight + 4);
            graphics.setFont(NODE_FONT);
            graphics.drawString(label, 4, (int)fontHeight + (int)condRectHeight + 4);
            graphics.translate(0.0, condRectHeight + labelRectHeight);
            this.paintAdditionalGraphics(node.getAdditionalGraphics(), graphics, (int)condRectWidth);
        } else {
            double rectWidth = Math.max(conditionRect.getWidth() + 8.0, (double)width);
            double rectHeight = Math.max(conditionRect.getHeight() + 8.0, (double)height);
            RoundRectangle2D.Double box = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectHeight, 20.0, 20.0);
            box.setFrame(0.0, 0.0, rectWidth, rectHeight);
            graphics.setColor(conditionColor);
            graphics.setStroke(new BasicStroke(1.0f, 0, 0));
            graphics.fill(box);
            graphics.setColor(conditionBorderColor);
            graphics.draw(box);
            graphics.setColor(Color.BLACK);
            graphics.setFont(CONDITION_FONT);
            graphics.drawString(nodeCondition, 4, (int)fontHeight + 4);
            graphics.translate(0.0, rectHeight);
            this.paintAdditionalGraphics(node.getAdditionalGraphics(), graphics, (int)rectWidth);
        }
    }

    private void paintAdditionalGraphics(Collection<AdditionalInformation> additionals, Graphics2D graphics, int width) {
        Graphics2D contextGraphics = (Graphics2D)graphics.create();
        for (AdditionalInformation currentGraphic : additionals) {
            int currentHeight = currentGraphic.getMinHeight(graphics);
            currentGraphic.paint(contextGraphics, width, currentHeight);
            contextGraphics.translate(currentHeight, 0);
        }
    }
}

