/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AdditionalInformation;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTreeNode
implements TreeNode {
    private SplitCondition condition;
    private double label;
    private ExampleSet nodeTrainExampleSet;
    private String stringLabel;
    private List<TreeNode> children;
    private Collection<AdditionalInformation> additionalGraphics = new ArrayList<AdditionalInformation>();

    public SimpleTreeNode(SplitCondition condition) {
        this.condition = condition;
        this.children = new LinkedList<TreeNode>();
    }

    public SimpleTreeNode(SplitCondition condition, ExampleSet nodeTrainExampleSet) {
        this.condition = condition;
        this.children = new LinkedList<TreeNode>();
        this.nodeTrainExampleSet = nodeTrainExampleSet;
    }

    @Override
    public SplitCondition getNodeCondition() {
        return this.condition;
    }

    @Override
    public boolean isInNode(Example example) {
        return this.condition.testExample(example);
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public void addChild(TreeNode childNode) {
        this.children.add(childNode);
    }

    @Override
    public int getNumberOfChildren() {
        return this.children.size();
    }

    @Override
    public void setLabel(double label) {
        this.label = label;
    }

    @Override
    public void setStringLabel(String stringLabel) {
        this.stringLabel = stringLabel;
    }

    @Override
    public double getLabel() {
        return this.label;
    }

    @Override
    public String getStringLabel() {
        return this.stringLabel;
    }

    @Override
    public Iterator<TreeNode> childIterator() {
        return this.children.iterator();
    }

    @Override
    public Collection<AdditionalInformation> getAdditionalGraphics() {
        return this.additionalGraphics;
    }

    @Override
    public boolean hasAdditionalGraphic() {
        return !this.additionalGraphics.isEmpty();
    }

    @Override
    public void addAdditionalGraphic(AdditionalInformation addition) {
        this.additionalGraphics.add(addition);
    }

    @Override
    public ExampleSet getTrainExampleSet() {
        return this.nodeTrainExampleSet;
    }

    @Override
    public void removeTrainExampleSet() {
        this.nodeTrainExampleSet = null;
    }

    @Override
    public void pruneChildren() {
        this.children.clear();
    }
}

