/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.learner.splitLearner.Split;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreePrePruner;

public class SimpleRegressionPrePruner
implements TreePrePruner {
    int minimalLeafSetSize;
    double minimalSplitBenefit;

    public SimpleRegressionPrePruner(int minimalLeafSetSize, double minimalSplitBenefit) {
        this.minimalLeafSetSize = minimalLeafSetSize;
        this.minimalSplitBenefit = minimalSplitBenefit;
    }

    public boolean prePrune(ExampleSet exampleSet) {
        return false;
    }

    public boolean prePrune(ExampleSet exampleSet, Split split) {
        SplittedExampleSet splittedSets = split.getSplittedExampleSet(exampleSet);
        if (splittedSets != null) {
            int i = 0;
            while (i < split.getNumberOfSplitPartitions()) {
                splittedSets.clearSelection();
                splittedSets.selectSingleSubset(i);
                if (splittedSets.size() < this.minimalLeafSetSize) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public double prePrunedLabel(ExampleSet exampleSet) {
        return 0.0;
    }
}

