/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NominalAttributeStatistics;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.learner.splitLearner.Split;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreePrePruner;
import java.util.Iterator;

public class SimplePrePruner
implements TreePrePruner {
    int minimalLeafSetSize;
    double minimalSplitBenefit;

    public SimplePrePruner(int minimalLeafSetSize, double minimalSplitBenefit) {
        this.minimalLeafSetSize = minimalLeafSetSize;
        this.minimalSplitBenefit = minimalSplitBenefit;
    }

    public boolean prePrune(ExampleSet exampleSet) {
        return false;
    }

    public boolean prePrune(ExampleSet exampleSet, Split split) {
        SplittedExampleSet splittedSets = split.getSplittedExampleSet(exampleSet);
        if (splittedSets != null) {
            int i = 0;
            while (i < split.getNumberOfSplitPartitions()) {
                splittedSets.clearSelection();
                splittedSets.selectSingleSubset(i);
                if (splittedSets.size() < this.minimalLeafSetSize) {
                    return true;
                }
                ++i;
            }
        }
        if (exampleSet.size() == 2) {
            return this.isSingleLabeled(exampleSet) || split.getSplitBenefit() < this.minimalSplitBenefit;
        }
        return this.isSingleLabeled(exampleSet) || split.getSplitBenefit() < this.minimalSplitBenefit;
    }

    public double prePrunedLabel(ExampleSet exampleSet) {
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        exampleSet.recalculateAttributeStatistics(labelAttribute);
        double test = ((NominalAttributeStatistics)labelAttribute.getStatistics()).getMode();
        return test;
    }

    private boolean isSingleLabeled(ExampleSet exampleSet) {
        Iterator iterator = exampleSet.iterator();
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        double labelValue = ((Example)iterator.next()).getValue(labelAttribute);
        while (iterator.hasNext()) {
            if (labelValue == ((Example)iterator.next()).getValue(labelAttribute)) continue;
            return false;
        }
        return true;
    }
}

